# Related Person Relationship Types (HDR) - HL7 Czech Hospital Discharge Report Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Related Person Relationship Types (HDR)**

HL7 Czech Hospital Discharge Report Implementation Guide, published by HL7 Czech Republic. This guide is not an authorized publication; it is the continuous build for version 0.0.2 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7-cz/hdr/](https://github.com/HL7-cz/hdr/) and changes regularly. See the [Directory of published versions](https://hl7.cz/fhir/hdr/history.html)

*  [Narrative Content](#) 
*  [XML](ValueSet-relatedPersonRelationshipTypes-eu-hdr.xml.md) 
*  [JSON](ValueSet-relatedPersonRelationshipTypes-eu-hdr.json.md) 
*  [TTL](ValueSet-relatedPersonRelationshipTypes-eu-hdr.ttl.md) 

## ValueSet: Related Person Relationship Types (HDR) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/ValueSet/relatedPersonRelationshipTypes-eu-hdr | *Version*:0.0.2 | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:RelatedPersonRelationshipTypesHDR |

 
HDR related person relationship types value set. 

 **References** 

* [Related Person: HDR (CZ)](StructureDefinition-cz-relatedPerson-hdr.md)

### Logical Definition (CLD)

* Include these codes as defined in [`http://terminology.hl7.org/CodeSystem/v3-RoleCode`](http://terminology.hl7.org/6.5.0/CodeSystem-v3-RoleCode.html)

 

### Expansion

Expansion from tx.fhir.org based on:

* [codesystem RoleCode v3.0.0 (CodeSystem)](http://terminology.hl7.org/6.5.0/CodeSystem-v3-RoleCode.html)
* [supplement RoleCode (CZ Supplement) v0.1.0 (CodeSystem)](https://build.fhir.org/ig/HL7-cz/terminology/CodeSystem-v3-RoleCode-cz.html)

This value set contains 3 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

 IG © 2025+ [HL7 Czech Republic](https://www.hl7.cz/). Package hl7.fhir.cz.hdr#0.0.2 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

