# Exposure of transmissible agents - HL7 Czech Hospital Discharge Report Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Exposure of transmissible agents**

HL7 Czech Hospital Discharge Report Implementation Guide, published by HL7 Czech Republic. This guide is not an authorized publication; it is the continuous build for version 0.0.2 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7-cz/hdr/](https://github.com/HL7-cz/hdr/) and changes regularly. See the [Directory of published versions](https://hl7.cz/fhir/hdr/history.html)

*  [Narrative Content](#) 
*  [XML](ValueSet-exposureAgent-eu-hdr.xml.md) 
*  [JSON](ValueSet-exposureAgent-eu-hdr.json.md) 
*  [TTL](ValueSet-exposureAgent-eu-hdr.ttl.md) 

## ValueSet: Exposure of transmissible agents 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/ValueSet/exposureAgent-eu-hdr | *Version*:0.0.2 | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:ExposureAgentHdrVs |
| **Copyright/Legal**: This value set includes content from SNOMED CT, which is copyright © 2002+ International Health Terminology Standards Development Organisation (IHTSDO), and distributed by agreement between IHTSDO and HL7. Implementer use of SNOMED CT is not covered by this agreement | | |

 
HDR exposure agent value set. This value set includes codes from SNOMED Clinical Terms®: all descendants of 40733004 "Infectious disease (disorder)" and ICD-10 all descendants of chapter I: "Certain infectious and parasitic diseases" 

 **References** 

* [Observation: Infectious Contact (HDR CZ)](StructureDefinition-cz-observation-infectious-contact-hdr.md)

### Logical Definition (CLD)

This value set includes codes based on the following rules:

* Include codes from[`http://hl7.org/fhir/sid/icd-10`](http://terminology.hl7.org/6.5.0/CodeSystem-icd10.html) where concept descends from I (Certain infectious and parasitic diseases)
* Include codes from[`http://snomed.info/sct`](http://www.snomed.org/) where concept descends from 40733004 (Infectious disease)

 

### Expansion

Expansion from tx.fhir.org based on:

* codesystem ICD-10 version2019-covid-expanded
* SNOMED CT International edition 01-Feb 2025

This value set has >1000 codes in it. In order to keep the publication size manageable, only a selection (1000 codes) of the whole set of codes is shown

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

 IG © 2025+ [HL7 Czech Republic](https://www.hl7.cz/). Package hl7.fhir.cz.hdr#0.0.2 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

