# CZ Consent Category - HL7 Czech Hospital Discharge Report Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CZ Consent Category**

HL7 Czech Hospital Discharge Report Implementation Guide, published by HL7 Czech Republic. This guide is not an authorized publication; it is the continuous build for version 0.0.2 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7-cz/hdr/](https://github.com/HL7-cz/hdr/) and changes regularly. See the [Directory of published versions](https://hl7.cz/fhir/hdr/history.html)

*  [Narrative Content](#) 
*  [XML](ValueSet-cz-consent-category.xml.md) 
*  [JSON](ValueSet-cz-consent-category.json.md) 
*  [TTL](ValueSet-cz-consent-category.ttl.md) 

## ValueSet: CZ Consent Category 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/ValueSet/cz-consent-category | *Version*:0.0.2 |
| Active as of 2025-10-01 | *Computable Name*:CZConsentCategory |

 
ValueSet for Consent Categories in the Czech HDR project. 

 **References** 

* [Consent (Advance Directives) (HDR CZ)](StructureDefinition-cz-consent-hdr.md)

### Logical Definition (CLD)

* Include all codes defined in [`http://snomed.info/sct`](http://www.snomed.org/)

 

### Expansion

This value set cannot be expanded because the terminology server(s) deemed it too costly to do so

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

 IG © 2025+ [HL7 Czech Republic](https://www.hl7.cz/). Package hl7.fhir.cz.hdr#0.0.2 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

