# Procedure (HDR CZ) - HL7 Czech Hospital Discharge Report Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Procedure (HDR CZ)**

HL7 Czech Hospital Discharge Report Implementation Guide, published by HL7 Czech Republic. This guide is not an authorized publication; it is the continuous build for version 0.0.2 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7-cz/hdr/](https://github.com/HL7-cz/hdr/) and changes regularly. See the [Directory of published versions](https://hl7.cz/fhir/hdr/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-cz-procedure-hdr-definitions.md) 
*  [Mappings](StructureDefinition-cz-procedure-hdr-mappings.md) 
*  [Examples](StructureDefinition-cz-procedure-hdr-examples.md) 
*  [XML](StructureDefinition-cz-procedure-hdr.profile.xml.md) 
*  [JSON](StructureDefinition-cz-procedure-hdr.profile.json.md) 
*  [TTL](StructureDefinition-cz-procedure-hdr.profile.ttl.md) 

## Resource Profile: Procedure (HDR CZ) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/StructureDefinition/cz-procedure-hdr | *Version*:0.0.2 |
| Draft as of 2025-10-01 | *Computable Name*:CZ_ProcedureHdr |

 
This profile represents the constraints applied to the Procedure resource by this guide. 

**Usages:**

* Derived from this Profile: [Procedure: Obligations](StructureDefinition-cz-procedure-obl-hdr.md)
* Use this Profile: [Bundle (HDR CZ)](StructureDefinition-cz-bundle-hdr.md)
* Refer to this Profile: [Composition (HDR CZ)](StructureDefinition-cz-composition-hdr.md)
* Examples for this Profile: [Procedure/CZ-Procedure-HDR-Example-Acute-appendicitis](Procedure-CZ-Procedure-HDR-Example-Acute-appendicitis.md), [Procedure/ColonoscopyProcedure](Procedure-ColonoscopyProcedure.md), [Procedure/Procedure-Appendectomy](Procedure-Procedure-Appendectomy.md), [Procedure/Procedure-Insert-Pacemaker](Procedure-Procedure-Insert-Pacemaker.md)...Show 3 more,[Procedure/Procedure-Insert-Pacemaker2](Procedure-Procedure-Insert-Pacemaker2.md),[Procedure/Procedure-No-Procedure](Procedure-Procedure-No-Procedure.md)and[Procedure/ffb1a62f-9050-4e33-af4b-4cdb8203c9e5](Procedure-ffb1a62f-9050-4e33-af4b-4cdb8203c9e5.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.hdr|current/StructureDefinition/cz-procedure-hdr)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Terminology Bindings

#### Constraints

This structure is derived from [Procedure](http://hl7.org/fhir/R4/procedure.html) 

#### Terminology Bindings (Differential)

#### Terminology Bindings

#### Constraints

This structure is derived from [Procedure](http://hl7.org/fhir/R4/procedure.html) 

**Summary**

Mandatory: 4 elements

**Structures**

This structure refers to these other structures:

* [Body structure: Laboratory(http://hl7.eu/fhir/laboratory/StructureDefinition/BodyStructure-eu-lab|0.2.0-ci)](https://build.fhir.org/ig/hl7-eu/laboratory/StructureDefinition-BodyStructure-eu-lab.html)
* [Codeable Concept (IPS)(http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips)](http://hl7.org/fhir/uv/ips/STU1.1/StructureDefinition-CodeableConcept-uv-ips.html)
* [Patient (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-patient-core.html)
* [Practitioner Role (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-practitionerrole-core.html)
* [Practitioner (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-practitioner-core.html)
* [Medical Device (CZ)(https://hl7.cz/fhir/core/StructureDefinition/cz-medical-device)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-medical-device.html)
* [Organization (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-organization-core.html)

**Extensions**

This structure refers to these extensions:

* [http://hl7.org/fhir/StructureDefinition/procedure-targetBodyStructure|5.2.0](http://hl7.org/fhir/extensions/5.2.0/StructureDefinition-procedure-targetBodyStructure.html)
* [http://hl7.org/fhir/StructureDefinition/data-absent-reason|5.2.0](http://hl7.org/fhir/extensions/5.2.0/StructureDefinition-data-absent-reason.html)

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Differential View** 

This structure is derived from [Procedure](http://hl7.org/fhir/R4/procedure.html) 

#### Terminology Bindings (Differential)

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [Procedure](http://hl7.org/fhir/R4/procedure.html) 

**Summary**

Mandatory: 4 elements

**Structures**

This structure refers to these other structures:

* [Body structure: Laboratory(http://hl7.eu/fhir/laboratory/StructureDefinition/BodyStructure-eu-lab|0.2.0-ci)](https://build.fhir.org/ig/hl7-eu/laboratory/StructureDefinition-BodyStructure-eu-lab.html)
* [Codeable Concept (IPS)(http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips)](http://hl7.org/fhir/uv/ips/STU1.1/StructureDefinition-CodeableConcept-uv-ips.html)
* [Patient (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-patient-core.html)
* [Practitioner Role (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-practitionerrole-core.html)
* [Practitioner (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-practitioner-core.html)
* [Medical Device (CZ)(https://hl7.cz/fhir/core/StructureDefinition/cz-medical-device)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-medical-device.html)
* [Organization (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-organization-core.html)

**Extensions**

This structure refers to these extensions:

* [http://hl7.org/fhir/StructureDefinition/procedure-targetBodyStructure|5.2.0](http://hl7.org/fhir/extensions/5.2.0/StructureDefinition-procedure-targetBodyStructure.html)
* [http://hl7.org/fhir/StructureDefinition/data-absent-reason|5.2.0](http://hl7.org/fhir/extensions/5.2.0/StructureDefinition-data-absent-reason.html)

 

Other representations of profile: [CSV](StructureDefinition-cz-procedure-hdr.csv), [Excel](StructureDefinition-cz-procedure-hdr.xlsx), [Schematron](StructureDefinition-cz-procedure-hdr.sch) 

 IG © 2025+ [HL7 Czech Republic](https://www.hl7.cz/). Package hl7.fhir.cz.hdr#0.0.2 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

