# Procedure (HDR CZ) - Examples - HL7 Czech Hospital Discharge Report Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Procedure (HDR CZ)**

HL7 Czech Hospital Discharge Report Implementation Guide, published by HL7 Czech Republic. This guide is not an authorized publication; it is the continuous build for version 0.0.2 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7-cz/hdr/](https://github.com/HL7-cz/hdr/) and changes regularly. See the [Directory of published versions](https://hl7.cz/fhir/hdr/history.html)

*  [Content](StructureDefinition-cz-procedure-hdr.md) 
*  [Detailed Descriptions](StructureDefinition-cz-procedure-hdr-definitions.md) 
*  [Mappings](StructureDefinition-cz-procedure-hdr-mappings.md) 
*  [Examples](#) 
*  [XML](StructureDefinition-cz-procedure-hdr.profile.xml.md) 
*  [JSON](StructureDefinition-cz-procedure-hdr.profile.json.md) 
*  [TTL](StructureDefinition-cz-procedure-hdr.profile.ttl.md) 

## Resource Profile: CZ_ProcedureHdr - Examples

| |
| :--- |
| Draft as of 2025-10-01 |

Examples for the cz-procedure-hdr Profile.

| |
| :--- |
| [CZ-Procedure-HDR Example - Acute appendicitis](Procedure-CZ-Procedure-HDR-Example-Acute-appendicitis.md) |
| [CZ-Procedure-HDR Example - Colonoscopy](Procedure-ColonoscopyProcedure.md) |
| [CZ-Procedure-HDR Example - Appendectomy](Procedure-Procedure-Appendectomy.md) |
| [CZ-Procedure-HDR Example - Pacemaker](Procedure-Procedure-Insert-Pacemaker.md) |
| [CZ-Procedure-HDR Example - Pacemaker](Procedure-Procedure-Insert-Pacemaker2.md) |
| [CZ-Procedure-HDR Example - No known procedures](Procedure-Procedure-No-Procedure.md) |
| [CZ-Procedure-HDR Example - Inguinal hernia](Procedure-ffb1a62f-9050-4e33-af4b-4cdb8203c9e5.md) |

 IG © 2025+ [HL7 Czech Republic](https://www.hl7.cz/). Package hl7.fhir.cz.hdr#0.0.2 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

