# Observation: SDOH (HDR CZ) - HL7 Czech Hospital Discharge Report Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Observation: SDOH (HDR CZ)**

HL7 Czech Hospital Discharge Report Implementation Guide, published by HL7 Czech Republic. This guide is not an authorized publication; it is the continuous build for version 0.0.2 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7-cz/hdr/](https://github.com/HL7-cz/hdr/) and changes regularly. See the [Directory of published versions](https://hl7.cz/fhir/hdr/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-cz-observation-sdoh-hdr-definitions.md) 
*  [Mappings](StructureDefinition-cz-observation-sdoh-hdr-mappings.md) 
*  [Examples](StructureDefinition-cz-observation-sdoh-hdr-examples.md) 
*  [XML](StructureDefinition-cz-observation-sdoh-hdr.profile.xml.md) 
*  [JSON](StructureDefinition-cz-observation-sdoh-hdr.profile.json.md) 
*  [TTL](StructureDefinition-cz-observation-sdoh-hdr.profile.ttl.md) 

## Resource Profile: Observation: SDOH (HDR CZ) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/StructureDefinition/cz-observation-sdoh-hdr | *Version*:0.0.2 |
| Draft as of 2025-10-01 | *Computable Name*:CZ_ObservationSdohHdr |

 
Profile for Social Determinants of Health (SDOH) observations that involve assessment (e.g., by a provider, payer, etc.) as opposed to being derived only from screening surveys (as is the case for the SDOHCC Screening Response Observation). 

**Usages:**

* Refer to this Profile: [Composition (HDR CZ)](StructureDefinition-cz-composition-hdr.md)
* Examples for this Profile: [Observation/3f85726c-ad2f-441b-89ce-10000000001c](Observation-3f85726c-ad2f-441b-89ce-10000000001c.md), [Observation/3f85726c-ad2f-441b-89ce-10000000001d](Observation-3f85726c-ad2f-441b-89ce-10000000001d.md), [Observation/3f85726c-ad2f-441b-89ce-100000000022](Observation-3f85726c-ad2f-441b-89ce-100000000022.md), [Observation/3f85726c-ad2f-441b-89ce-100000000023](Observation-3f85726c-ad2f-441b-89ce-100000000023.md)...Show 7 more,[Observation/3f85726c-ad2f-441b-89ce-100000000024](Observation-3f85726c-ad2f-441b-89ce-100000000024.md),[Observation/3f85726c-ad2f-441b-89ce-100000000025](Observation-3f85726c-ad2f-441b-89ce-100000000025.md),[Observation/3f85726c-ad2f-441b-89ce-100000000027](Observation-3f85726c-ad2f-441b-89ce-100000000027.md),[Observation/CZObservationSdohHdrExample](Observation-CZObservationSdohHdrExample.md),[Observation/ExampleSdohAlcohol](Observation-ExampleSdohAlcohol.md),[Observation/ExampleSdohSmoking](Observation-ExampleSdohSmoking.md)and[Observation/Observation-Education-level](Observation-Observation-Education-level.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.hdr|current/StructureDefinition/cz-observation-sdoh-hdr)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Terminology Bindings

#### Constraints

This structure is derived from [Observation](http://hl7.org/fhir/R4/observation.html) 

#### Terminology Bindings (Differential)

#### Terminology Bindings

#### Constraints

This structure is derived from [Observation](http://hl7.org/fhir/R4/observation.html) 

**Summary**

Mandatory: 3 elements(1 nested mandatory element)

**Structures**

This structure refers to these other structures:

* [Patient (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-patient-core.html)
* [Related Person (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-relatedPerson-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-relatedPerson-core.html)
* [Practitioner (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-practitioner-core.html)
* [Practitioner Role (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-practitionerrole-core.html)
* [Organization (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-organization-core.html)

**Slices**

This structure defines the following [Slices](http://hl7.org/fhir/R4/profiling.html#slices):

* The element 1 is sliced based on the value of Observation.category

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Differential View** 

This structure is derived from [Observation](http://hl7.org/fhir/R4/observation.html) 

#### Terminology Bindings (Differential)

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [Observation](http://hl7.org/fhir/R4/observation.html) 

**Summary**

Mandatory: 3 elements(1 nested mandatory element)

**Structures**

This structure refers to these other structures:

* [Patient (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-patient-core.html)
* [Related Person (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-relatedPerson-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-relatedPerson-core.html)
* [Practitioner (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-practitioner-core.html)
* [Practitioner Role (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-practitionerrole-core.html)
* [Organization (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-organization-core.html)

**Slices**

This structure defines the following [Slices](http://hl7.org/fhir/R4/profiling.html#slices):

* The element 1 is sliced based on the value of Observation.category

 

Other representations of profile: [CSV](StructureDefinition-cz-observation-sdoh-hdr.csv), [Excel](StructureDefinition-cz-observation-sdoh-hdr.xlsx), [Schematron](StructureDefinition-cz-observation-sdoh-hdr.sch) 

 IG © 2025+ [HL7 Czech Republic](https://www.hl7.cz/). Package hl7.fhir.cz.hdr#0.0.2 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

