# Observation: Anthropometric Data (HDR CZ) - Height - HL7 Czech Hospital Discharge Report Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Observation: Anthropometric Data (HDR CZ) - Height**

HL7 Czech Hospital Discharge Report Implementation Guide, published by HL7 Czech Republic. This guide is not an authorized publication; it is the continuous build for version 0.0.2 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7-cz/hdr/](https://github.com/HL7-cz/hdr/) and changes regularly. See the [Directory of published versions](https://hl7.cz/fhir/hdr/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-cz-observation-height-hdr-definitions.md) 
*  [Mappings](StructureDefinition-cz-observation-height-hdr-mappings.md) 
*  [Examples](StructureDefinition-cz-observation-height-hdr-examples.md) 
*  [XML](StructureDefinition-cz-observation-height-hdr.profile.xml.md) 
*  [JSON](StructureDefinition-cz-observation-height-hdr.profile.json.md) 
*  [TTL](StructureDefinition-cz-observation-height-hdr.profile.ttl.md) 

## Resource Profile: Observation: Anthropometric Data (HDR CZ) - Height 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/StructureDefinition/cz-observation-height-hdr | *Version*:0.0.2 |
| Draft as of 2025-10-01 | *Computable Name*:CZ_ObservationHeightHdr |

 
This profile sets minimum expectations for the Observation resource to record, search, and fetch anthropometric measurements such as height, weight, BMI, and optional measurements like head, chest, and abdominal circumference. 

**Usages:**

* Examples for this Profile: [Observation/6bec5d97-a17e-4015-8fce-7b1c0c3a2f4b](Observation-6bec5d97-a17e-4015-8fce-7b1c0c3a2f4b.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.hdr|current/StructureDefinition/cz-observation-height-hdr)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Terminology Bindings

#### Constraints

This structure is derived from [Observation](http://hl7.org/fhir/R4/observation.html) 

#### Terminology Bindings

#### Constraints

This structure is derived from [Observation](http://hl7.org/fhir/R4/observation.html) 

**Summary**

Mandatory: 2 elements

**Structures**

This structure refers to these other structures:

* [Patient (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-patient-core.html)

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Differential View** 

This structure is derived from [Observation](http://hl7.org/fhir/R4/observation.html) 

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [Observation](http://hl7.org/fhir/R4/observation.html) 

**Summary**

Mandatory: 2 elements

**Structures**

This structure refers to these other structures:

* [Patient (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-patient-core.html)

 

Other representations of profile: [CSV](StructureDefinition-cz-observation-height-hdr.csv), [Excel](StructureDefinition-cz-observation-height-hdr.xlsx), [Schematron](StructureDefinition-cz-observation-height-hdr.sch) 

 IG © 2025+ [HL7 Czech Republic](https://www.hl7.cz/). Package hl7.fhir.cz.hdr#0.0.2 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

