# MedicationRequest (HDR CZ) - HL7 Czech Hospital Discharge Report Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **MedicationRequest (HDR CZ)**

HL7 Czech Hospital Discharge Report Implementation Guide, published by HL7 Czech Republic. This guide is not an authorized publication; it is the continuous build for version 0.0.2 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7-cz/hdr/](https://github.com/HL7-cz/hdr/) and changes regularly. See the [Directory of published versions](https://hl7.cz/fhir/hdr/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-cz-medicationRequest-hdr-definitions.md) 
*  [Mappings](StructureDefinition-cz-medicationRequest-hdr-mappings.md) 
*  [XML](StructureDefinition-cz-medicationRequest-hdr.profile.xml.md) 
*  [JSON](StructureDefinition-cz-medicationRequest-hdr.profile.json.md) 
*  [TTL](StructureDefinition-cz-medicationRequest-hdr.profile.ttl.md) 

## Resource Profile: MedicationRequest (HDR CZ) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/StructureDefinition/cz-medicationRequest-hdr | *Version*:0.0.2 | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:CZ_MedicationRequestHdr |

 
This profile constrains the MedicationRequest resource for the purpose of this guide, adapted from the MPD work. 

**Usages:**

* Derived from this Profile: [MedicationRequest: Obligations (HDR CZ) - hospital stay](StructureDefinition-cz-medicationrequest-hospitalstay-obl-hdr.md) and [MedicationRequest: Obligations (HDR CZ) - medication summary](StructureDefinition-cz-medicationrequest-medicationsummary-obl-hdr.md)
* Use this Profile: [Bundle (HDR CZ)](StructureDefinition-cz-bundle-hdr.md)
* Refer to this Profile: [Composition (HDR CZ)](StructureDefinition-cz-composition-hdr.md) and [MedicationDispense (HDR)](StructureDefinition-cz-medicationDispense-hdr.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.hdr|current/StructureDefinition/cz-medicationRequest-hdr)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Terminology Bindings

#### Constraints

This structure is derived from [MedicationRequest](http://hl7.org/fhir/R4/medicationrequest.html) 

#### Terminology Bindings

#### Constraints

This structure is derived from [MedicationRequest](http://hl7.org/fhir/R4/medicationrequest.html) 

**Summary**

Mandatory: 4 elements(1 nested mandatory element)

**Structures**

This structure refers to these other structures:

* [Medication (CZ)(https://hl7.cz/fhir/core/StructureDefinition/cz-Medication)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-Medication.html)
* [Patient (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-patient-core.html)
* [SimpleQuantity(http://hl7.org/fhir/StructureDefinition/SimpleQuantity)](http://hl7.org/fhir/R4/datatypes.html#SimpleQuantity)

**Slices**

This structure defines the following [Slices](http://hl7.org/fhir/R4/profiling.html#slices):

* The element 1 is sliced based on the value of MedicationRequest.medication[x]
* The element 1 is sliced based on the value of MedicationRequest.dosageInstruction.doseAndRate.dose[x]
* The element 1 is sliced based on the value of MedicationRequest.substitution.allowed[x]

**[Maturity](http://hl7.org/fhir/versions.html#maturity)**: 1

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Differential View** 

This structure is derived from [MedicationRequest](http://hl7.org/fhir/R4/medicationrequest.html) 

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [MedicationRequest](http://hl7.org/fhir/R4/medicationrequest.html) 

**Summary**

Mandatory: 4 elements(1 nested mandatory element)

**Structures**

This structure refers to these other structures:

* [Medication (CZ)(https://hl7.cz/fhir/core/StructureDefinition/cz-Medication)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-Medication.html)
* [Patient (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-patient-core.html)
* [SimpleQuantity(http://hl7.org/fhir/StructureDefinition/SimpleQuantity)](http://hl7.org/fhir/R4/datatypes.html#SimpleQuantity)

**Slices**

This structure defines the following [Slices](http://hl7.org/fhir/R4/profiling.html#slices):

* The element 1 is sliced based on the value of MedicationRequest.medication[x]
* The element 1 is sliced based on the value of MedicationRequest.dosageInstruction.doseAndRate.dose[x]
* The element 1 is sliced based on the value of MedicationRequest.substitution.allowed[x]

**[Maturity](http://hl7.org/fhir/versions.html#maturity)**: 1

 

Other representations of profile: [CSV](StructureDefinition-cz-medicationRequest-hdr.csv), [Excel](StructureDefinition-cz-medicationRequest-hdr.xlsx), [Schematron](StructureDefinition-cz-medicationRequest-hdr.sch) 

 IG © 2025+ [HL7 Czech Republic](https://www.hl7.cz/). Package hl7.fhir.cz.hdr#0.0.2 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

