# MedicationDispense (HDR) - HL7 Czech Hospital Discharge Report Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **MedicationDispense (HDR)**

HL7 Czech Hospital Discharge Report Implementation Guide, published by HL7 Czech Republic. This guide is not an authorized publication; it is the continuous build for version 0.0.2 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7-cz/hdr/](https://github.com/HL7-cz/hdr/) and changes regularly. See the [Directory of published versions](https://hl7.cz/fhir/hdr/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-cz-medicationDispense-hdr-definitions.md) 
*  [Mappings](StructureDefinition-cz-medicationDispense-hdr-mappings.md) 
*  [XML](StructureDefinition-cz-medicationDispense-hdr.profile.xml.md) 
*  [JSON](StructureDefinition-cz-medicationDispense-hdr.profile.json.md) 
*  [TTL](StructureDefinition-cz-medicationDispense-hdr.profile.ttl.md) 

## Resource Profile: MedicationDispense (HDR) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/StructureDefinition/cz-medicationDispense-hdr | *Version*:0.0.2 | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:CZ_MedicationDispenseHdr |

 
This profile constrains the MedicationDispense resource for the purpose of this guide, adapted from the MPD work. 

**Usages:**

* Derived from this Profile: [MedicationDispense: Obligations (HDR CZ) - hospital stay](StructureDefinition-cz-medicationdispens-hospitalstay-obl-hdr.md) and [MedicationDispense: Obligations (HDR CZ) - medication summary](StructureDefinition-cz-medicationdispens-medicationsummary-obl-hdr.md)
* Refer to this Profile: [Composition (HDR CZ)](StructureDefinition-cz-composition-hdr.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.hdr|current/StructureDefinition/cz-medicationDispense-hdr)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Terminology Bindings

#### Constraints

This structure is derived from [MedicationDispense](http://hl7.org/fhir/R4/medicationdispense.html) 

#### Terminology Bindings

#### Constraints

This structure is derived from [MedicationDispense](http://hl7.org/fhir/R4/medicationdispense.html) 

**Summary**

Mandatory: 2 elements

**Structures**

This structure refers to these other structures:

* [Medication (CZ)(https://hl7.cz/fhir/core/StructureDefinition/cz-Medication)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-Medication.html)
* [Patient (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-patient-core.html)
* [MedicationRequest (HDR CZ)(https://hl7.cz/fhir/hdr/StructureDefinition/cz-medicationRequest-hdr)](StructureDefinition-cz-medicationRequest-hdr.md)

**[Maturity](http://hl7.org/fhir/versions.html#maturity)**: 1

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Differential View** 

This structure is derived from [MedicationDispense](http://hl7.org/fhir/R4/medicationdispense.html) 

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [MedicationDispense](http://hl7.org/fhir/R4/medicationdispense.html) 

**Summary**

Mandatory: 2 elements

**Structures**

This structure refers to these other structures:

* [Medication (CZ)(https://hl7.cz/fhir/core/StructureDefinition/cz-Medication)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-Medication.html)
* [Patient (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-patient-core.html)
* [MedicationRequest (HDR CZ)(https://hl7.cz/fhir/hdr/StructureDefinition/cz-medicationRequest-hdr)](StructureDefinition-cz-medicationRequest-hdr.md)

**[Maturity](http://hl7.org/fhir/versions.html#maturity)**: 1

 

Other representations of profile: [CSV](StructureDefinition-cz-medicationDispense-hdr.csv), [Excel](StructureDefinition-cz-medicationDispense-hdr.xlsx), [Schematron](StructureDefinition-cz-medicationDispense-hdr.sch) 

 IG © 2025+ [HL7 Czech Republic](https://www.hl7.cz/). Package hl7.fhir.cz.hdr#0.0.2 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

