# Immunization Recommendation Obligations (HDR CZ) - HL7 Czech Hospital Discharge Report Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Immunization Recommendation Obligations (HDR CZ)**

HL7 Czech Hospital Discharge Report Implementation Guide, published by HL7 Czech Republic. This guide is not an authorized publication; it is the continuous build for version 0.0.2 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7-cz/hdr/](https://github.com/HL7-cz/hdr/) and changes regularly. See the [Directory of published versions](https://hl7.cz/fhir/hdr/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-cz-immunizationrecommendation-obl-hdr-definitions.md) 
*  [Mappings](StructureDefinition-cz-immunizationrecommendation-obl-hdr-mappings.md) 
*  [XML](StructureDefinition-cz-immunizationrecommendation-obl-hdr.profile.xml.md) 
*  [JSON](StructureDefinition-cz-immunizationrecommendation-obl-hdr.profile.json.md) 
*  [TTL](StructureDefinition-cz-immunizationrecommendation-obl-hdr.profile.ttl.md) 

## Resource Profile: Immunization Recommendation Obligations (HDR CZ) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/StructureDefinition/cz-immunizationrecommendation-obl-hdr | *Version*:0.0.2 | |
| *Standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 0 | *Computable Name*:CZ_ImmunizationRecommendationObligationsHdr |

 
This profile defines the obligations for the ImmunizationRecommendation resource used in the HDR CZ project. 

**Usages:**

* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.hdr|current/StructureDefinition/cz-immunizationrecommendation-obl-hdr)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Terminology Bindings

#### Constraints

This structure is derived from [CZ_ImmunizationRecommendationHdr](StructureDefinition-cz-immunizationRecommendation-hdr.md) 

#### Terminology Bindings

#### Constraints

This structure is derived from [CZ_ImmunizationRecommendationHdr](StructureDefinition-cz-immunizationRecommendation-hdr.md) 

**Summary**

**[Maturity](http://hl7.org/fhir/versions.html#maturity)**: 0

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Differential View** 

This structure is derived from [CZ_ImmunizationRecommendationHdr](StructureDefinition-cz-immunizationRecommendation-hdr.md) 

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [CZ_ImmunizationRecommendationHdr](StructureDefinition-cz-immunizationRecommendation-hdr.md) 

**Summary**

**[Maturity](http://hl7.org/fhir/versions.html#maturity)**: 0

 

Other representations of profile: [CSV](StructureDefinition-cz-immunizationrecommendation-obl-hdr.csv), [Excel](StructureDefinition-cz-immunizationrecommendation-obl-hdr.xlsx), [Schematron](StructureDefinition-cz-immunizationrecommendation-obl-hdr.sch) 

 IG © 2025+ [HL7 Czech Republic](https://www.hl7.cz/). Package hl7.fhir.cz.hdr#0.0.2 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

