# ImmunizationRecommendation (CZ HDR) - HL7 Czech Hospital Discharge Report Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **ImmunizationRecommendation (CZ HDR)**

HL7 Czech Hospital Discharge Report Implementation Guide, published by HL7 Czech Republic. This guide is not an authorized publication; it is the continuous build for version 0.0.2 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7-cz/hdr/](https://github.com/HL7-cz/hdr/) and changes regularly. See the [Directory of published versions](https://hl7.cz/fhir/hdr/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-cz-immunizationRecommendation-hdr-definitions.md) 
*  [Mappings](StructureDefinition-cz-immunizationRecommendation-hdr-mappings.md) 
*  [Examples](StructureDefinition-cz-immunizationRecommendation-hdr-examples.md) 
*  [XML](StructureDefinition-cz-immunizationRecommendation-hdr.profile.xml.md) 
*  [JSON](StructureDefinition-cz-immunizationRecommendation-hdr.profile.json.md) 
*  [TTL](StructureDefinition-cz-immunizationRecommendation-hdr.profile.ttl.md) 

## Resource Profile: ImmunizationRecommendation (CZ HDR) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/StructureDefinition/cz-immunizationRecommendation-hdr | *Version*:0.0.2 |
| Draft as of 2025-10-01 | *Computable Name*:CZ_ImmunizationRecommendationHdr |

 
This profile defines how to represent Immunization Recommandations for the purpose of this guide. 

**Usages:**

* Derived from this Profile: [Immunization Recommendation Obligations (HDR CZ)](StructureDefinition-cz-immunizationrecommendation-obl-hdr.md)
* Refer to this Profile: [Immunization (HDR CZ)](StructureDefinition-cz-immunization-hdr.md)
* Examples for this Profile: [ImmunizationRecommendation/ImmunizationRecommendation](ImmunizationRecommendation-ImmunizationRecommendation.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.hdr|current/StructureDefinition/cz-immunizationRecommendation-hdr)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Terminology Bindings

#### Constraints

This structure is derived from [ImmunizationRecommendation](http://hl7.org/fhir/R4/immunizationrecommendation.html) 

#### Terminology Bindings (Differential)

#### Terminology Bindings

#### Constraints

This structure is derived from [ImmunizationRecommendation](http://hl7.org/fhir/R4/immunizationrecommendation.html) 

**Summary**

**Structures**

This structure refers to these other structures:

* [Patient (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-patient-core.html)

**Slices**

This structure defines the following [Slices](http://hl7.org/fhir/R4/profiling.html#slices):

* The element 1 is sliced based on the value of ImmunizationRecommendation.recommendation.dateCriterion
* The element 1 is sliced based on the value of ImmunizationRecommendation.recommendation.doseNumber[x]
* The element 1 is sliced based on the value of ImmunizationRecommendation.recommendation.seriesDoses[x]

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Differential View** 

This structure is derived from [ImmunizationRecommendation](http://hl7.org/fhir/R4/immunizationrecommendation.html) 

#### Terminology Bindings (Differential)

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [ImmunizationRecommendation](http://hl7.org/fhir/R4/immunizationrecommendation.html) 

**Summary**

**Structures**

This structure refers to these other structures:

* [Patient (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-patient-core.html)

**Slices**

This structure defines the following [Slices](http://hl7.org/fhir/R4/profiling.html#slices):

* The element 1 is sliced based on the value of ImmunizationRecommendation.recommendation.dateCriterion
* The element 1 is sliced based on the value of ImmunizationRecommendation.recommendation.doseNumber[x]
* The element 1 is sliced based on the value of ImmunizationRecommendation.recommendation.seriesDoses[x]

 

Other representations of profile: [CSV](StructureDefinition-cz-immunizationRecommendation-hdr.csv), [Excel](StructureDefinition-cz-immunizationRecommendation-hdr.xlsx), [Schematron](StructureDefinition-cz-immunizationRecommendation-hdr.sch) 

 IG © 2025+ [HL7 Czech Republic](https://www.hl7.cz/). Package hl7.fhir.cz.hdr#0.0.2 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

