# Immunization (HDR CZ) - HL7 Czech Hospital Discharge Report Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Immunization (HDR CZ)**

HL7 Czech Hospital Discharge Report Implementation Guide, published by HL7 Czech Republic. This guide is not an authorized publication; it is the continuous build for version 0.0.2 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7-cz/hdr/](https://github.com/HL7-cz/hdr/) and changes regularly. See the [Directory of published versions](https://hl7.cz/fhir/hdr/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-cz-immunization-hdr-definitions.md) 
*  [Mappings](StructureDefinition-cz-immunization-hdr-mappings.md) 
*  [Examples](StructureDefinition-cz-immunization-hdr-examples.md) 
*  [XML](StructureDefinition-cz-immunization-hdr.profile.xml.md) 
*  [JSON](StructureDefinition-cz-immunization-hdr.profile.json.md) 
*  [TTL](StructureDefinition-cz-immunization-hdr.profile.ttl.md) 

## Resource Profile: Immunization (HDR CZ) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/StructureDefinition/cz-immunization-hdr | *Version*:0.0.2 |
| Draft as of 2025-10-01 | *Computable Name*:CZ_ImmunizationHdr |

 
This profile constrains the Immunization resource for the purpose of this guide. 

 
This profile constrains the Immunization resource for the purpose of this guide. 

**Usages:**

* Derived from this Profile: [Immunization Obligations: HDR CZ](StructureDefinition-cz-immunization-obl-hdr.md)
* Refer to this Profile: [Composition (HDR CZ)](StructureDefinition-cz-composition-hdr.md)
* Examples for this Profile: [Immunization/3f85726c-ad2f-441b-89ce-10000000001e](Immunization-3f85726c-ad2f-441b-89ce-10000000001e.md) and [Immunization/Immunization-CovidExample](Immunization-Immunization-CovidExample.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.hdr|current/StructureDefinition/cz-immunization-hdr)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Terminology Bindings

#### Constraints

This structure is derived from [Immunization](http://hl7.org/fhir/R4/immunization.html) 

#### Terminology Bindings (Differential)

#### Terminology Bindings

#### Constraints

This structure is derived from [Immunization](http://hl7.org/fhir/R4/immunization.html) 

**Summary**

**Structures**

This structure refers to these other structures:

* [ImmunizationRecommendation (CZ HDR)(https://hl7.cz/fhir/hdr/StructureDefinition/cz-immunizationRecommendation-hdr)](StructureDefinition-cz-immunizationRecommendation-hdr.md)
* [Medication (CZ)(https://hl7.cz/fhir/core/StructureDefinition/cz-Medication)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-Medication.html)
* [Patient (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-patient-core.html)
* [Organization (EU core)(http://hl7.eu/fhir/base/StructureDefinition/organization-eu-core|0.1.0-ci-build)](https://build.fhir.org/ig/hl7-eu/base/StructureDefinition-organization-eu-core.html)
* [PractitionerRole (EU core)(http://hl7.eu/fhir/base/StructureDefinition/practitionerRole-eu-core|0.1.0-ci-build)](https://build.fhir.org/ig/hl7-eu/base/StructureDefinition-practitionerRole-eu-core.html)
* [Practitioner (EU core)(http://hl7.eu/fhir/base/StructureDefinition/practitioner-eu-core|0.1.0-ci-build)](https://build.fhir.org/ig/hl7-eu/base/StructureDefinition-practitioner-eu-core.html)

**Extensions**

This structure refers to these extensions:

* [http://hl7.org/fhir/5.0/StructureDefinition/extension-Immunization.basedOn](http://hl7.org/fhir/R4/immunization-definitions.html#Immunization.basedOn)
* [http://hl7.eu/fhir/hdr/StructureDefinition/immunization-administeredProduct](http://hl7.eu/fhir/hdr/0.1.0-ballot/StructureDefinition-immunization-administeredProduct.html)

**Slices**

This structure defines the following [Slices](http://hl7.org/fhir/R4/profiling.html#slices):

* The element 1 is sliced based on the value of Immunization.performer
* The element 1 is sliced based on the value of Immunization.protocolApplied.doseNumber[x]
* The element 1 is sliced based on the value of Immunization.protocolApplied.seriesDoses[x]

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Differential View** 

This structure is derived from [Immunization](http://hl7.org/fhir/R4/immunization.html) 

#### Terminology Bindings (Differential)

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [Immunization](http://hl7.org/fhir/R4/immunization.html) 

**Summary**

**Structures**

This structure refers to these other structures:

* [ImmunizationRecommendation (CZ HDR)(https://hl7.cz/fhir/hdr/StructureDefinition/cz-immunizationRecommendation-hdr)](StructureDefinition-cz-immunizationRecommendation-hdr.md)
* [Medication (CZ)(https://hl7.cz/fhir/core/StructureDefinition/cz-Medication)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-Medication.html)
* [Patient (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-patient-core.html)
* [Organization (EU core)(http://hl7.eu/fhir/base/StructureDefinition/organization-eu-core|0.1.0-ci-build)](https://build.fhir.org/ig/hl7-eu/base/StructureDefinition-organization-eu-core.html)
* [PractitionerRole (EU core)(http://hl7.eu/fhir/base/StructureDefinition/practitionerRole-eu-core|0.1.0-ci-build)](https://build.fhir.org/ig/hl7-eu/base/StructureDefinition-practitionerRole-eu-core.html)
* [Practitioner (EU core)(http://hl7.eu/fhir/base/StructureDefinition/practitioner-eu-core|0.1.0-ci-build)](https://build.fhir.org/ig/hl7-eu/base/StructureDefinition-practitioner-eu-core.html)

**Extensions**

This structure refers to these extensions:

* [http://hl7.org/fhir/5.0/StructureDefinition/extension-Immunization.basedOn](http://hl7.org/fhir/R4/immunization-definitions.html#Immunization.basedOn)
* [http://hl7.eu/fhir/hdr/StructureDefinition/immunization-administeredProduct](http://hl7.eu/fhir/hdr/0.1.0-ballot/StructureDefinition-immunization-administeredProduct.html)

**Slices**

This structure defines the following [Slices](http://hl7.org/fhir/R4/profiling.html#slices):

* The element 1 is sliced based on the value of Immunization.performer
* The element 1 is sliced based on the value of Immunization.protocolApplied.doseNumber[x]
* The element 1 is sliced based on the value of Immunization.protocolApplied.seriesDoses[x]

 

Other representations of profile: [CSV](StructureDefinition-cz-immunization-hdr.csv), [Excel](StructureDefinition-cz-immunization-hdr.xlsx), [Schematron](StructureDefinition-cz-immunization-hdr.sch) 

 IG © 2025+ [HL7 Czech Republic](https://www.hl7.cz/). Package hl7.fhir.cz.hdr#0.0.2 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

