# Flag (HDR CZ) - HL7 Czech Hospital Discharge Report Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Flag (HDR CZ)**

HL7 Czech Hospital Discharge Report Implementation Guide, published by HL7 Czech Republic. This guide is not an authorized publication; it is the continuous build for version 0.0.2 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7-cz/hdr/](https://github.com/HL7-cz/hdr/) and changes regularly. See the [Directory of published versions](https://hl7.cz/fhir/hdr/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-cz-flag-hdr-definitions.md) 
*  [Mappings](StructureDefinition-cz-flag-hdr-mappings.md) 
*  [Examples](StructureDefinition-cz-flag-hdr-examples.md) 
*  [XML](StructureDefinition-cz-flag-hdr.profile.xml.md) 
*  [JSON](StructureDefinition-cz-flag-hdr.profile.json.md) 
*  [TTL](StructureDefinition-cz-flag-hdr.profile.ttl.md) 

## Resource Profile: Flag (HDR CZ) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/StructureDefinition/cz-flag-hdr | *Version*:0.0.2 | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:CZ_FlagHdr |

 
This profile constrains the Flag resource to represent alerts or warnings in FHIR for the purpose of this project. 

**Usages:**

* Derived from this Profile: [Flag Obligations (HDR CZ)](StructureDefinition-cz-flag-obl-hdr.md)
* Use this Profile: [Bundle (HDR CZ)](StructureDefinition-cz-bundle-hdr.md)
* Examples for this Profile: [Flag/5a17a710-193e-4490-a627-7202925aa56e](Flag-5a17a710-193e-4490-a627-7202925aa56e.md) and [Flag/Flag1](Flag-Flag1.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.hdr|current/StructureDefinition/cz-flag-hdr)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Terminology Bindings

#### Constraints

This structure is derived from [Flag](http://hl7.org/fhir/R4/flag.html) 

#### Terminology Bindings

#### Constraints

This structure is derived from [Flag](http://hl7.org/fhir/R4/flag.html) 

**Summary**

**Structures**

This structure refers to these other structures:

* [Patient (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-patient-core.html)

**Extensions**

This structure refers to these extensions:

* [http://hl7.org/fhir/StructureDefinition/flag-detail|5.2.0](http://hl7.org/fhir/extensions/5.2.0/StructureDefinition-flag-detail.html)
* [http://hl7.org/fhir/StructureDefinition/flag-priority|5.2.0](http://hl7.org/fhir/extensions/5.2.0/StructureDefinition-flag-priority.html)

**[Maturity](http://hl7.org/fhir/versions.html#maturity)**: 1

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Differential View** 

This structure is derived from [Flag](http://hl7.org/fhir/R4/flag.html) 

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [Flag](http://hl7.org/fhir/R4/flag.html) 

**Summary**

**Structures**

This structure refers to these other structures:

* [Patient (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-patient-core.html)

**Extensions**

This structure refers to these extensions:

* [http://hl7.org/fhir/StructureDefinition/flag-detail|5.2.0](http://hl7.org/fhir/extensions/5.2.0/StructureDefinition-flag-detail.html)
* [http://hl7.org/fhir/StructureDefinition/flag-priority|5.2.0](http://hl7.org/fhir/extensions/5.2.0/StructureDefinition-flag-priority.html)

**[Maturity](http://hl7.org/fhir/versions.html#maturity)**: 1

 

Other representations of profile: [CSV](StructureDefinition-cz-flag-hdr.csv), [Excel](StructureDefinition-cz-flag-hdr.xlsx), [Schematron](StructureDefinition-cz-flag-hdr.sch) 

 IG © 2025+ [HL7 Czech Republic](https://www.hl7.cz/). Package hl7.fhir.cz.hdr#0.0.2 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

