# FamilyMemberHistory (HDR CZ) - HL7 Czech Hospital Discharge Report Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **FamilyMemberHistory (HDR CZ)**

HL7 Czech Hospital Discharge Report Implementation Guide, published by HL7 Czech Republic. This guide is not an authorized publication; it is the continuous build for version 0.0.2 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7-cz/hdr/](https://github.com/HL7-cz/hdr/) and changes regularly. See the [Directory of published versions](https://hl7.cz/fhir/hdr/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-cz-familyMemberHistory-hdr-definitions.md) 
*  [Mappings](StructureDefinition-cz-familyMemberHistory-hdr-mappings.md) 
*  [XML](StructureDefinition-cz-familyMemberHistory-hdr.profile.xml.md) 
*  [JSON](StructureDefinition-cz-familyMemberHistory-hdr.profile.json.md) 
*  [TTL](StructureDefinition-cz-familyMemberHistory-hdr.profile.ttl.md) 

## Resource Profile: FamilyMemberHistory (HDR CZ) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/StructureDefinition/cz-familyMemberHistory-hdr | *Version*:0.0.2 |
| Draft as of 2025-10-01 | *Computable Name*:CZ_FamilyMemberHistoryHdr |

 
This profile represents the constraints applied to the FamilyMemberHistory resource by this guide. 

**Usages:**

* Refer to this Profile: [Composition (HDR CZ)](StructureDefinition-cz-composition-hdr.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.hdr|current/StructureDefinition/cz-familyMemberHistory-hdr)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Terminology Bindings

#### Constraints

This structure is derived from [FamilyMemberHistory](http://hl7.org/fhir/R4/familymemberhistory.html) 

#### Terminology Bindings (Differential)

#### Terminology Bindings

#### Constraints

This structure is derived from [FamilyMemberHistory](http://hl7.org/fhir/R4/familymemberhistory.html) 

**Summary**

**Structures**

This structure refers to these other structures:

* [Patient (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-patient-core.html)
* [Codeable Concept (IPS)(http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips)](http://hl7.org/fhir/uv/ips/STU1.1/StructureDefinition-CodeableConcept-uv-ips.html)

**Slices**

This structure defines the following [Slices](http://hl7.org/fhir/R4/profiling.html#slices):

* The element 1 is sliced based on the value of FamilyMemberHistory.born[x]
* The element 1 is sliced based on the value of FamilyMemberHistory.deceased[x]

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Differential View** 

This structure is derived from [FamilyMemberHistory](http://hl7.org/fhir/R4/familymemberhistory.html) 

#### Terminology Bindings (Differential)

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [FamilyMemberHistory](http://hl7.org/fhir/R4/familymemberhistory.html) 

**Summary**

**Structures**

This structure refers to these other structures:

* [Patient (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-patient-core.html)
* [Codeable Concept (IPS)(http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips)](http://hl7.org/fhir/uv/ips/STU1.1/StructureDefinition-CodeableConcept-uv-ips.html)

**Slices**

This structure defines the following [Slices](http://hl7.org/fhir/R4/profiling.html#slices):

* The element 1 is sliced based on the value of FamilyMemberHistory.born[x]
* The element 1 is sliced based on the value of FamilyMemberHistory.deceased[x]

 

Other representations of profile: [CSV](StructureDefinition-cz-familyMemberHistory-hdr.csv), [Excel](StructureDefinition-cz-familyMemberHistory-hdr.xlsx), [Schematron](StructureDefinition-cz-familyMemberHistory-hdr.sch) 

 IG © 2025+ [HL7 Czech Republic](https://www.hl7.cz/). Package hl7.fhir.cz.hdr#0.0.2 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

