# Encounter: Obligations - HL7 Czech Hospital Discharge Report Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Encounter: Obligations**

HL7 Czech Hospital Discharge Report Implementation Guide, published by HL7 Czech Republic. This guide is not an authorized publication; it is the continuous build for version 0.0.2 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7-cz/hdr/](https://github.com/HL7-cz/hdr/) and changes regularly. See the [Directory of published versions](https://hl7.cz/fhir/hdr/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-cz-encounter-obl-hdr-definitions.md) 
*  [Mappings](StructureDefinition-cz-encounter-obl-hdr-mappings.md) 
*  [XML](StructureDefinition-cz-encounter-obl-hdr.profile.xml.md) 
*  [JSON](StructureDefinition-cz-encounter-obl-hdr.profile.json.md) 
*  [TTL](StructureDefinition-cz-encounter-obl-hdr.profile.ttl.md) 

## Resource Profile: Encounter: Obligations 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/StructureDefinition/cz-encounter-obl-hdr | *Version*:0.0.2 | |
| *Standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 0 | *Computable Name*:CZ_EncounterObligationsHdr |

 
This profile defines obligations for an Encounter in FHIR for the purpose of this guide. 

**Usages:**

* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.hdr|current/StructureDefinition/cz-encounter-obl-hdr)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Terminology Bindings

#### Constraints

This structure is derived from [CZ_EncounterHdr](StructureDefinition-cz-encounter-hdr.md) 

#### Terminology Bindings

#### Constraints

This structure is derived from [CZ_EncounterHdr](StructureDefinition-cz-encounter-hdr.md) 

**Summary**

**[Maturity](http://hl7.org/fhir/versions.html#maturity)**: 0

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Differential View** 

This structure is derived from [CZ_EncounterHdr](StructureDefinition-cz-encounter-hdr.md) 

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [CZ_EncounterHdr](StructureDefinition-cz-encounter-hdr.md) 

**Summary**

**[Maturity](http://hl7.org/fhir/versions.html#maturity)**: 0

 

Other representations of profile: [CSV](StructureDefinition-cz-encounter-obl-hdr.csv), [Excel](StructureDefinition-cz-encounter-obl-hdr.xlsx), [Schematron](StructureDefinition-cz-encounter-obl-hdr.sch) 

 IG © 2025+ [HL7 Czech Republic](https://www.hl7.cz/). Package hl7.fhir.cz.hdr#0.0.2 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

