# Encounter (HDR CZ) - HL7 Czech Hospital Discharge Report Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Encounter (HDR CZ)**

HL7 Czech Hospital Discharge Report Implementation Guide, published by HL7 Czech Republic. This guide is not an authorized publication; it is the continuous build for version 0.0.2 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7-cz/hdr/](https://github.com/HL7-cz/hdr/) and changes regularly. See the [Directory of published versions](https://hl7.cz/fhir/hdr/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-cz-encounter-hdr-definitions.md) 
*  [Mappings](StructureDefinition-cz-encounter-hdr-mappings.md) 
*  [Examples](StructureDefinition-cz-encounter-hdr-examples.md) 
*  [XML](StructureDefinition-cz-encounter-hdr.profile.xml.md) 
*  [JSON](StructureDefinition-cz-encounter-hdr.profile.json.md) 
*  [TTL](StructureDefinition-cz-encounter-hdr.profile.ttl.md) 

## Resource Profile: Encounter (HDR CZ) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/StructureDefinition/cz-encounter-hdr | *Version*:0.0.2 | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:CZ_EncounterHdr |

 
This profile defines how to represent Inpatient Encounter in HL7 FHIR for the scope of this guide. 

### Content (cs)

#### Encounter (HDR CZ)

Resource Encounter (HDR CZ) popisuje konkrétní kontakt pacienta se zdravotnickým zařízením. Je ústředním vazebním prvkem dokumentu – propojuje pacienta, poskytovatele, důvod hospitalizace, průběh, účastníky a místa pobytu. Slouží k zajištění kontinuity péče po propuštění a k možnosti sekundárního využití dat.

#### Základní identifikační údaje kontaktu pacienta se zdravotnickým zařízením

ID, metadata, identifikátory, stav kontaktu, typ péče.

#### Odkazy na související zdroje

pacient, epizody péče, objednávky vyšetření, účty pro vykazování.

#### Účastníci kontaktu

přijímající, propouštějící a doporučující lékaři, další odborníci zapojení do péče, včetně jejich rolí a časových úseků účasti.

#### Časové údaje

období kontaktu, délka, případně návaznost na jiný kontakt.

#### Důvody a diagnózy

kódované i textové důvody hospitalizace, odkazy na stavy (Condition) a postupy (Procedure), role diagnóz (přijetí, propuštění…).

#### Podrobnosti o hospitalizaci

zdroj přijetí, opakovaná hospitalizace, dietní preference, zvláštní ujednání, cílové místo a dispozice při propuštění.

#### Umístění pacienta

oddělení, lůžko, stav lokality a fyzický typ, s časovým vymezením.

#### Poskytovatel služby

organizace odpovědná za tento kontakt.

-------

-------

**Usages:**

* Derived from this Profile: [Encounter: Obligations](StructureDefinition-cz-encounter-obl-hdr.md)
* Use this Profile: [Bundle (HDR CZ)](StructureDefinition-cz-bundle-hdr.md)
* Refer to this Profile: [Composition (HDR CZ)](StructureDefinition-cz-composition-hdr.md)
* Examples for this Profile: [Encounter/10f5c49e-086d-4016-8dd1-b555306bf620](Encounter-10f5c49e-086d-4016-8dd1-b555306bf620.md), [Encounter/CZ-Encounter-HDR-Example](Encounter-CZ-Encounter-HDR-Example.md), [Encounter/HospitalEncounter](Encounter-HospitalEncounter.md) and [Encounter/f08151d0-a7ad-4a7b-b7b9-97eb1d394ffb](Encounter-f08151d0-a7ad-4a7b-b7b9-97eb1d394ffb.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.hdr|current/StructureDefinition/cz-encounter-hdr)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Terminology Bindings

#### Constraints

This structure is derived from [Encounter](http://hl7.org/fhir/R4/encounter.html) 

#### Terminology Bindings (Differential)

#### Terminology Bindings

#### Constraints

This structure is derived from [Encounter](http://hl7.org/fhir/R4/encounter.html) 

**Summary**

Mandatory: 3 elements(3 nested mandatory elements)

**Structures**

This structure refers to these other structures:

* [Patient (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-patient-core.html)
* [Practitioner (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-practitioner-core.html)
* [Practitioner Role (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-practitionerrole-core.html)
* [Condition (HDR CZ)(https://hl7.cz/fhir/hdr/StructureDefinition/cz-condition-hdr)](StructureDefinition-cz-condition-hdr.md)
* [Organization (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-organization-core.html)
* [Location (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-location-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-location-core.html)

**Slices**

This structure defines the following [Slices](http://hl7.org/fhir/R4/profiling.html#slices):

* The element 1 is sliced based on the value of Encounter.participant

**[Maturity](http://hl7.org/fhir/versions.html#maturity)**: 1

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Differential View** 

This structure is derived from [Encounter](http://hl7.org/fhir/R4/encounter.html) 

#### Terminology Bindings (Differential)

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [Encounter](http://hl7.org/fhir/R4/encounter.html) 

**Summary**

Mandatory: 3 elements(3 nested mandatory elements)

**Structures**

This structure refers to these other structures:

* [Patient (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-patient-core.html)
* [Practitioner (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-practitioner-core.html)
* [Practitioner Role (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-practitionerrole-core.html)
* [Condition (HDR CZ)(https://hl7.cz/fhir/hdr/StructureDefinition/cz-condition-hdr)](StructureDefinition-cz-condition-hdr.md)
* [Organization (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-organization-core.html)
* [Location (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-location-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-location-core.html)

**Slices**

This structure defines the following [Slices](http://hl7.org/fhir/R4/profiling.html#slices):

* The element 1 is sliced based on the value of Encounter.participant

**[Maturity](http://hl7.org/fhir/versions.html#maturity)**: 1

 

Other representations of profile: [CSV](StructureDefinition-cz-encounter-hdr.csv), [Excel](StructureDefinition-cz-encounter-hdr.xlsx), [Schematron](StructureDefinition-cz-encounter-hdr.sch) 

 IG © 2025+ [HL7 Czech Republic](https://www.hl7.cz/). Package hl7.fhir.cz.hdr#0.0.2 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

