# Encounter (HDR CZ) - Examples - HL7 Czech Hospital Discharge Report Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Encounter (HDR CZ)**

HL7 Czech Hospital Discharge Report Implementation Guide, published by HL7 Czech Republic. This guide is not an authorized publication; it is the continuous build for version 0.0.2 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7-cz/hdr/](https://github.com/HL7-cz/hdr/) and changes regularly. See the [Directory of published versions](https://hl7.cz/fhir/hdr/history.html)

*  [Content](StructureDefinition-cz-encounter-hdr.md) 
*  [Detailed Descriptions](StructureDefinition-cz-encounter-hdr-definitions.md) 
*  [Mappings](StructureDefinition-cz-encounter-hdr-mappings.md) 
*  [Examples](#) 
*  [XML](StructureDefinition-cz-encounter-hdr.profile.xml.md) 
*  [JSON](StructureDefinition-cz-encounter-hdr.profile.json.md) 
*  [TTL](StructureDefinition-cz-encounter-hdr.profile.ttl.md) 

## Resource Profile: CZ_EncounterHdr - Examples

| | |
| :--- | :--- |
| *Page standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 |

Examples for the cz-encounter-hdr Profile.

| |
| :--- |
| [CZ-Encounter-HDR Example of encounter with emergency priority](Encounter-10f5c49e-086d-4016-8dd1-b555306bf620.md) |
| [CZ-Encounter-HDR Example](Encounter-CZ-Encounter-HDR-Example.md) |
| [CZ-Encounter-HDR Example of finished hospital encounter](Encounter-HospitalEncounter.md) |
| [CZ-Encounter-HDR Example of encounter for Novak Petr](Encounter-f08151d0-a7ad-4a7b-b7b9-97eb1d394ffb.md) |

 IG © 2025+ [HL7 Czech Republic](https://www.hl7.cz/). Package hl7.fhir.cz.hdr#0.0.2 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

