# DeviceUseStatement (HDR) - HL7 Czech Hospital Discharge Report Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **DeviceUseStatement (HDR)**

HL7 Czech Hospital Discharge Report Implementation Guide, published by HL7 Czech Republic. This guide is not an authorized publication; it is the continuous build for version 0.0.2 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7-cz/hdr/](https://github.com/HL7-cz/hdr/) and changes regularly. See the [Directory of published versions](https://hl7.cz/fhir/hdr/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-cz-deviceUseStatement-hdr-definitions.md) 
*  [Mappings](StructureDefinition-cz-deviceUseStatement-hdr-mappings.md) 
*  [Examples](StructureDefinition-cz-deviceUseStatement-hdr-examples.md) 
*  [XML](StructureDefinition-cz-deviceUseStatement-hdr.profile.xml.md) 
*  [JSON](StructureDefinition-cz-deviceUseStatement-hdr.profile.json.md) 
*  [TTL](StructureDefinition-cz-deviceUseStatement-hdr.profile.ttl.md) 

## Resource Profile: DeviceUseStatement (HDR) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/StructureDefinition/cz-deviceUseStatement-hdr | *Version*:0.0.2 |
| Draft as of 2025-10-01 | *Computable Name*:CZ_DeviceUseStatementHdr |

 
This profile represents the constraints applied to the DeviceUseStatement resource for the purpose of this guide. A device used by or implanted on the patient is described in the hospital discharge report as an instance of a Device resource constrained by this profile. 

**Usages:**

* Refer to this Profile: [Composition (HDR CZ)](StructureDefinition-cz-composition-hdr.md)
* Examples for this Profile: [DeviceUseStatement/DeviceUseStatement-Pacemaker](DeviceUseStatement-DeviceUseStatement-Pacemaker.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.hdr|current/StructureDefinition/cz-deviceUseStatement-hdr)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Terminology Bindings

#### Constraints

This structure is derived from [DeviceUseStatement](http://hl7.org/fhir/R4/deviceusestatement.html) 

#### Terminology Bindings (Differential)

#### Terminology Bindings

#### Constraints

This structure is derived from [DeviceUseStatement](http://hl7.org/fhir/R4/deviceusestatement.html) 

**Summary**

Mandatory: 2 elements

**Structures**

This structure refers to these other structures:

* [Patient (EU core)(http://hl7.eu/fhir/base/StructureDefinition/patient-eu-core|0.1.0-ci-build)](https://build.fhir.org/ig/hl7-eu/base/StructureDefinition-patient-eu-core.html)
* [Device (HDR)(http://hl7.eu/fhir/hdr/StructureDefinition/device-eu-hdr)](http://hl7.eu/fhir/hdr/0.1.0-ballot/StructureDefinition-device-eu-hdr.html)
* [Condition (HDR)(http://hl7.eu/fhir/hdr/StructureDefinition/condition-eu-hdr)](http://hl7.eu/fhir/hdr/0.1.0-ballot/StructureDefinition-condition-eu-hdr.html)
* [Codeable Concept (IPS)(http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips)](http://hl7.org/fhir/uv/ips/STU1.1/StructureDefinition-CodeableConcept-uv-ips.html)

**Extensions**

This structure refers to these extensions:

* [http://hl7.org/fhir/StructureDefinition/data-absent-reason|5.2.0](http://hl7.org/fhir/extensions/5.2.0/StructureDefinition-data-absent-reason.html)

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Differential View** 

This structure is derived from [DeviceUseStatement](http://hl7.org/fhir/R4/deviceusestatement.html) 

#### Terminology Bindings (Differential)

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [DeviceUseStatement](http://hl7.org/fhir/R4/deviceusestatement.html) 

**Summary**

Mandatory: 2 elements

**Structures**

This structure refers to these other structures:

* [Patient (EU core)(http://hl7.eu/fhir/base/StructureDefinition/patient-eu-core|0.1.0-ci-build)](https://build.fhir.org/ig/hl7-eu/base/StructureDefinition-patient-eu-core.html)
* [Device (HDR)(http://hl7.eu/fhir/hdr/StructureDefinition/device-eu-hdr)](http://hl7.eu/fhir/hdr/0.1.0-ballot/StructureDefinition-device-eu-hdr.html)
* [Condition (HDR)(http://hl7.eu/fhir/hdr/StructureDefinition/condition-eu-hdr)](http://hl7.eu/fhir/hdr/0.1.0-ballot/StructureDefinition-condition-eu-hdr.html)
* [Codeable Concept (IPS)(http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips)](http://hl7.org/fhir/uv/ips/STU1.1/StructureDefinition-CodeableConcept-uv-ips.html)

**Extensions**

This structure refers to these extensions:

* [http://hl7.org/fhir/StructureDefinition/data-absent-reason|5.2.0](http://hl7.org/fhir/extensions/5.2.0/StructureDefinition-data-absent-reason.html)

 

Other representations of profile: [CSV](StructureDefinition-cz-deviceUseStatement-hdr.csv), [Excel](StructureDefinition-cz-deviceUseStatement-hdr.xlsx), [Schematron](StructureDefinition-cz-deviceUseStatement-hdr.sch) 

 IG © 2025+ [HL7 Czech Republic](https://www.hl7.cz/). Package hl7.fhir.cz.hdr#0.0.2 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

