# Consent (Advance Directives) (HDR CZ) - HL7 Czech Hospital Discharge Report Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Consent (Advance Directives) (HDR CZ)**

HL7 Czech Hospital Discharge Report Implementation Guide, published by HL7 Czech Republic. This guide is not an authorized publication; it is the continuous build for version 0.0.2 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7-cz/hdr/](https://github.com/HL7-cz/hdr/) and changes regularly. See the [Directory of published versions](https://hl7.cz/fhir/hdr/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-cz-consent-hdr-definitions.md) 
*  [Mappings](StructureDefinition-cz-consent-hdr-mappings.md) 
*  [Examples](StructureDefinition-cz-consent-hdr-examples.md) 
*  [XML](StructureDefinition-cz-consent-hdr.profile.xml.md) 
*  [JSON](StructureDefinition-cz-consent-hdr.profile.json.md) 
*  [TTL](StructureDefinition-cz-consent-hdr.profile.ttl.md) 

## Resource Profile: Consent (Advance Directives) (HDR CZ) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/StructureDefinition/cz-consent-hdr | *Version*:0.0.2 | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:CZ_ConsentHdr |

 
This profile constrains the Consent resource for the purpose of representing Advance Directives in this project. 

 
This profile constrains the Consent resource to model Advance Directives, documenting a patient's future medical decisions. 

**Usages:**

* Derived from this Profile: [Consent Obligations (HDR CZ)](StructureDefinition-cz-consent-obl-hdr.md)
* Refer to this Profile: [Composition (HDR CZ)](StructureDefinition-cz-composition-hdr.md)
* Examples for this Profile: [Consent/CZ-AdvanceDirectives-HDR-DNR](Consent-CZ-AdvanceDirectives-HDR-DNR.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.hdr|current/StructureDefinition/cz-consent-hdr)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Terminology Bindings

#### Constraints

This structure is derived from [Consent](http://hl7.org/fhir/R4/consent.html) 

#### Terminology Bindings (Differential)

#### Terminology Bindings

#### Constraints

This structure is derived from [Consent](http://hl7.org/fhir/R4/consent.html) 

**Summary**

Mandatory: 1 element

**[Maturity](http://hl7.org/fhir/versions.html#maturity)**: 1

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Differential View** 

This structure is derived from [Consent](http://hl7.org/fhir/R4/consent.html) 

#### Terminology Bindings (Differential)

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [Consent](http://hl7.org/fhir/R4/consent.html) 

**Summary**

Mandatory: 1 element

**[Maturity](http://hl7.org/fhir/versions.html#maturity)**: 1

 

Other representations of profile: [CSV](StructureDefinition-cz-consent-hdr.csv), [Excel](StructureDefinition-cz-consent-hdr.xlsx), [Schematron](StructureDefinition-cz-consent-hdr.sch) 

 IG © 2025+ [HL7 Czech Republic](https://www.hl7.cz/). Package hl7.fhir.cz.hdr#0.0.2 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

