# Condition (HDR CZ) - HL7 Czech Hospital Discharge Report Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Condition (HDR CZ)**

HL7 Czech Hospital Discharge Report Implementation Guide, published by HL7 Czech Republic. This guide is not an authorized publication; it is the continuous build for version 0.0.2 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7-cz/hdr/](https://github.com/HL7-cz/hdr/) and changes regularly. See the [Directory of published versions](https://hl7.cz/fhir/hdr/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-cz-condition-hdr-definitions.md) 
*  [Mappings](StructureDefinition-cz-condition-hdr-mappings.md) 
*  [Examples](StructureDefinition-cz-condition-hdr-examples.md) 
*  [XML](StructureDefinition-cz-condition-hdr.profile.xml.md) 
*  [JSON](StructureDefinition-cz-condition-hdr.profile.json.md) 
*  [TTL](StructureDefinition-cz-condition-hdr.profile.ttl.md) 

## Resource Profile: Condition (HDR CZ) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/StructureDefinition/cz-condition-hdr | *Version*:0.0.2 |
| Draft as of 2025-10-01 | *Computable Name*:CZ_ConditionHdr |

 
This profile represents the constraint applied to the Condition in the scope of this guide. It supports the Diagnostic summary part of the eHN data model adding two additional categories: First category distinguishes conditions present at admission and acquired during hospital stay, while second category is used to indicate impact of the condition to the treatment during hospital stay (treated, untreated). 

**Usages:**

* Use this Profile: [Bundle (HDR CZ)](StructureDefinition-cz-bundle-hdr.md)
* Refer to this Profile: [Care Plan (HDR CZ)](StructureDefinition-cz-carePlan-hdr.md), [Composition (HDR CZ)](StructureDefinition-cz-composition-hdr.md) and [Encounter (HDR CZ)](StructureDefinition-cz-encounter-hdr.md)
* Examples for this Profile: [Condition/35717696-8a99-4f99-a938-ec0ec88a65a2](Condition-35717696-8a99-4f99-a938-ec0ec88a65a2.md), [Condition/AngiodysplasiaCondition](Condition-AngiodysplasiaCondition.md), [Condition/AtrialFibrillationCondition](Condition-AtrialFibrillationCondition.md), [Condition/CZ-Condition-HDR-Example-2](Condition-CZ-Condition-HDR-Example-2.md)...Show 10 more,[Condition/CZ-Condition-HDR-Example-3](Condition-CZ-Condition-HDR-Example-3.md),[Condition/CZ-Condition-HDR-Example](Condition-CZ-Condition-HDR-Example.md),[Condition/HypercholesterolemiaCondition](Condition-HypercholesterolemiaCondition.md),[Condition/HypothyroidismCondition](Condition-HypothyroidismCondition.md),[Condition/IronDeficiencyAnemiaCondition](Condition-IronDeficiencyAnemiaCondition.md),[Condition/OsteoporosisCondition](Condition-OsteoporosisCondition.md),[Condition/PresbycusisCondition](Condition-PresbycusisCondition.md),[Condition/TIACondition](Condition-TIACondition.md),[Condition/VaricoseVeinsCondition](Condition-VaricoseVeinsCondition.md)and[Condition/fdf9e92d-ac48-4706-b15b-d2eaca85f45f](Condition-fdf9e92d-ac48-4706-b15b-d2eaca85f45f.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.hdr|current/StructureDefinition/cz-condition-hdr)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Terminology Bindings

#### Constraints

This structure is derived from [Condition](http://hl7.org/fhir/R4/condition.html) 

#### Terminology Bindings (Differential)

#### Terminology Bindings

#### Constraints

This structure is derived from [Condition](http://hl7.org/fhir/R4/condition.html) 

**Summary**

Mandatory: 2 elements

**Structures**

This structure refers to these other structures:

* [Body structure: Laboratory(http://hl7.eu/fhir/laboratory/StructureDefinition/BodyStructure-eu-lab|0.2.0-ci)](https://build.fhir.org/ig/hl7-eu/laboratory/StructureDefinition-BodyStructure-eu-lab.html)
* [Codeable Concept (IPS)(http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips)](http://hl7.org/fhir/uv/ips/STU1.1/StructureDefinition-CodeableConcept-uv-ips.html)
* [Patient (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-patient-core.html)

**Extensions**

This structure refers to these extensions:

* [http://hl7.org/fhir/StructureDefinition/bodySite|5.2.0](http://hl7.org/fhir/extensions/5.2.0/StructureDefinition-bodySite.html)

**Slices**

This structure defines the following [Slices](http://hl7.org/fhir/R4/profiling.html#slices):

* The element 1 is sliced based on the value of Condition.category
* The element 1 is sliced based on the value of Condition.onset[x]
* The element 1 is sliced based on the value of Condition.abatement[x]

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Differential View** 

This structure is derived from [Condition](http://hl7.org/fhir/R4/condition.html) 

#### Terminology Bindings (Differential)

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [Condition](http://hl7.org/fhir/R4/condition.html) 

**Summary**

Mandatory: 2 elements

**Structures**

This structure refers to these other structures:

* [Body structure: Laboratory(http://hl7.eu/fhir/laboratory/StructureDefinition/BodyStructure-eu-lab|0.2.0-ci)](https://build.fhir.org/ig/hl7-eu/laboratory/StructureDefinition-BodyStructure-eu-lab.html)
* [Codeable Concept (IPS)(http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips)](http://hl7.org/fhir/uv/ips/STU1.1/StructureDefinition-CodeableConcept-uv-ips.html)
* [Patient (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-patient-core.html)

**Extensions**

This structure refers to these extensions:

* [http://hl7.org/fhir/StructureDefinition/bodySite|5.2.0](http://hl7.org/fhir/extensions/5.2.0/StructureDefinition-bodySite.html)

**Slices**

This structure defines the following [Slices](http://hl7.org/fhir/R4/profiling.html#slices):

* The element 1 is sliced based on the value of Condition.category
* The element 1 is sliced based on the value of Condition.onset[x]
* The element 1 is sliced based on the value of Condition.abatement[x]

 

Other representations of profile: [CSV](StructureDefinition-cz-condition-hdr.csv), [Excel](StructureDefinition-cz-condition-hdr.xlsx), [Schematron](StructureDefinition-cz-condition-hdr.sch) 

 IG © 2025+ [HL7 Czech Republic](https://www.hl7.cz/). Package hl7.fhir.cz.hdr#0.0.2 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

