# Composition (HDR CZ) - HL7 Czech Hospital Discharge Report Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Composition (HDR CZ)**

HL7 Czech Hospital Discharge Report Implementation Guide, published by HL7 Czech Republic. This guide is not an authorized publication; it is the continuous build for version 0.0.2 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7-cz/hdr/](https://github.com/HL7-cz/hdr/) and changes regularly. See the [Directory of published versions](https://hl7.cz/fhir/hdr/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-cz-composition-hdr-definitions.md) 
*  [Mappings](StructureDefinition-cz-composition-hdr-mappings.md) 
*  [Examples](StructureDefinition-cz-composition-hdr-examples.md) 
*  [XML](StructureDefinition-cz-composition-hdr.profile.xml.md) 
*  [JSON](StructureDefinition-cz-composition-hdr.profile.json.md) 
*  [TTL](StructureDefinition-cz-composition-hdr.profile.ttl.md) 

## Resource Profile: Composition (HDR CZ) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/StructureDefinition/cz-composition-hdr | *Version*:0.0.2 |
| Draft as of 2025-10-01 | *Computable Name*:CZ_CompositionHdr |

 
This profile defines how to represent Composition resource in HL7 FHIR for the scope of this guide. 

### Content (cs)

#### Composition (HDR CZ)

**Resource Composition (HDR CZ)** popisuje strukturu a obsahovou kostru propouštěcí zprávy. Je hlavním dokumentovým prvkem, který určuje formální hlavičku zprávy, identifikaci, status, datum a čas vytvoření, autora a příjemce. Obsahuje odkaz na pacienta, kontext hospitalizace a všechny obsahové sekce propouštěcí zprávy včetně narativního textu a vazeb na detailní zdroje.

Slouží k jednotnému a přehlednému zachycení informací o průběhu hospitalizace, provedených výkonech, zjištěných nálezech, podané léčbě, stavu při propuštění a doporučeních pro další péči.

-------

**Usages:**

* Derived from this Profile: [Composition: Obligations](StructureDefinition-cz-composition-obl-hdr.md)
* Use this Profile: [Bundle (HDR CZ)](StructureDefinition-cz-bundle-hdr.md)
* Examples for this Profile: [Composition/6891fd68-dc3c-4c91-a8d3-cb5ec990c035](Composition-6891fd68-dc3c-4c91-a8d3-cb5ec990c035.md), [Composition/6891fd68-dc3c-4c91-a8d3-cb5ec990c03b](Composition-6891fd68-dc3c-4c91-a8d3-cb5ec990c03b.md), [Composition/701f51d5-78bf-428e-a6b5-349c2614ce07](Composition-701f51d5-78bf-428e-a6b5-349c2614ce07.md) and [Composition/cdae7735-f7ee-4bc7-9cf3-3dc806a4eaaf](Composition-cdae7735-f7ee-4bc7-9cf3-3dc806a4eaaf.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.hdr|current/StructureDefinition/cz-composition-hdr)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Terminology Bindings

#### Constraints

This structure is derived from [Composition](http://hl7.org/fhir/R4/composition.html) 

#### Terminology Bindings

#### Constraints

This structure is derived from [Composition](http://hl7.org/fhir/R4/composition.html) 

**Summary**

Mandatory: 13 elements(124 nested mandatory elements)
 Fixed: 1 element
 Prohibited: 46 elements

**Structures**

This structure refers to these other structures:

* [Practitioner Role (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-practitionerrole-core.html)
* [Practitioner (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-practitioner-core.html)
* [Medical Device (CZ)(https://hl7.cz/fhir/core/StructureDefinition/cz-medical-device)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-medical-device.html)
* [Patient (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-patient-core.html)
* [Related Person (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-relatedPerson-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-relatedPerson-core.html)
* [Organization (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-organization-core.html)
* [Codeable Concept (IPS)(http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips)](http://hl7.org/fhir/uv/ips/STU1.1/StructureDefinition-CodeableConcept-uv-ips.html)
* [Encounter (HDR CZ)(https://hl7.cz/fhir/hdr/StructureDefinition/cz-encounter-hdr)](StructureDefinition-cz-encounter-hdr.md)
* [Condition (HDR CZ)(https://hl7.cz/fhir/hdr/StructureDefinition/cz-condition-hdr)](StructureDefinition-cz-condition-hdr.md)
* [Vital Signs Profile(http://hl7.org/fhir/StructureDefinition/vitalsigns)](http://hl7.org/fhir/R4/vitalsigns.html)
* [Allergy Intolerance (HDR CZ)(https://hl7.cz/fhir/hdr/StructureDefinition/cz-allergyIntolerance-hdr)](StructureDefinition-cz-allergyIntolerance-hdr.md)
* [Procedure (HDR CZ)(https://hl7.cz/fhir/hdr/StructureDefinition/cz-procedure-hdr)](StructureDefinition-cz-procedure-hdr.md)
* [DeviceUseStatement (HDR)(https://hl7.cz/fhir/hdr/StructureDefinition/cz-deviceUseStatement-hdr)](StructureDefinition-cz-deviceUseStatement-hdr.md)
* [MedicationDispense (HDR)(https://hl7.cz/fhir/hdr/StructureDefinition/cz-medicationDispense-hdr)](StructureDefinition-cz-medicationDispense-hdr.md)
* [Medication Statement (CZ)(https://hl7.cz/fhir/core/StructureDefinition/cz-MedicationStatement)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-MedicationStatement.html)
* [MedicationRequest (HDR CZ)(https://hl7.cz/fhir/hdr/StructureDefinition/cz-medicationRequest-hdr)](StructureDefinition-cz-medicationRequest-hdr.md)
* [Medication (CZ)(https://hl7.cz/fhir/core/StructureDefinition/cz-Medication)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-Medication.html)
* [Observation Laboratory (CZ)(https://hl7.cz/fhir/lab/StructureDefinition/cz-observation-result-laboratory)](https://build.fhir.org/ig/HL7-cz/cz-lab/StructureDefinition-cz-observation-result-laboratory.html)
* [Observation: Imaging Report (CZ)(https://hl7.cz/fhir/img/StructureDefinition/cz-observation-result-imaging)](https://build.fhir.org/ig/HL7-cz/img/StructureDefinition-cz-observation-result-imaging.html)
* [Condition (HDR)(http://hl7.eu/fhir/hdr/StructureDefinition/condition-eu-hdr)](http://hl7.eu/fhir/hdr/0.1.0-ballot/StructureDefinition-condition-eu-hdr.html)
* [Immunization (HDR CZ)(https://hl7.cz/fhir/hdr/StructureDefinition/cz-immunization-hdr)](StructureDefinition-cz-immunization-hdr.md)
* [ImmunizationRecommendation (HDR)(http://hl7.eu/fhir/hdr/StructureDefinition/immunizationRecommendation-eu-hdr)](http://hl7.eu/fhir/hdr/0.1.0-ballot/StructureDefinition-immunizationRecommendation-eu-hdr.html)
* [FamilyMemberHistory (HDR CZ)(https://hl7.cz/fhir/hdr/StructureDefinition/cz-familyMemberHistory-hdr)](StructureDefinition-cz-familyMemberHistory-hdr.md)
* [Condition (IPS)(http://hl7.org/fhir/uv/ips/StructureDefinition/Condition-uv-ips)](http://hl7.org/fhir/uv/ips/STU1.1/StructureDefinition-Condition-uv-ips.html)
* [Observation: SDOH (HDR CZ)(https://hl7.cz/fhir/hdr/StructureDefinition/cz-observation-sdoh-hdr)](StructureDefinition-cz-observation-sdoh-hdr.md)
* [Care Plan (HDR CZ)(https://hl7.cz/fhir/hdr/StructureDefinition/cz-carePlan-hdr)](StructureDefinition-cz-carePlan-hdr.md)
* [Coverage (CZ)(https://hl7.cz/fhir/core/StructureDefinition/cz-coverage)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-coverage.html)
* [Consent (Advance Directives) (HDR CZ)(https://hl7.cz/fhir/hdr/StructureDefinition/cz-consent-hdr)](StructureDefinition-cz-consent-hdr.md)
* [Observation: Infectious Contact (HDR CZ)(https://hl7.cz/fhir/hdr/StructureDefinition/cz-observation-infectious-contact-hdr)](StructureDefinition-cz-observation-infectious-contact-hdr.md)

**Extensions**

This structure refers to these extensions:

* [http://hl7.org/fhir/StructureDefinition/event-basedOn|5.2.0](http://hl7.org/fhir/extensions/5.2.0/StructureDefinition-event-basedOn.html)
* [http://hl7.eu/fhir/StructureDefinition/presentedForm|0.1.1-ci-build](https://build.fhir.org/ig/hl7-eu/extensions/StructureDefinition-presentedForm.html)
* [http://hl7.org/fhir/5.0/StructureDefinition/extension-Composition.version](http://hl7.org/fhir/R4/composition-definitions.html#Composition.version)
* [http://hl7.eu/fhir/StructureDefinition/information-recipient|0.5.0](https://build.fhir.org/ig/HL7-cz/cz-lab/StructureDefinition-information-recipient.html)

**Slices**

This structure defines the following [Slices](http://hl7.org/fhir/R4/profiling.html#slices):

* The element 1 is sliced based on the value of Composition.section
* The element 1 is sliced based on the value of Composition.section.section
* The element 1 is sliced based on the value of Composition.section.entry

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Differential View** 

This structure is derived from [Composition](http://hl7.org/fhir/R4/composition.html) 

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [Composition](http://hl7.org/fhir/R4/composition.html) 

**Summary**

Mandatory: 13 elements(124 nested mandatory elements)
 Fixed: 1 element
 Prohibited: 46 elements

**Structures**

This structure refers to these other structures:

* [Practitioner Role (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-practitionerrole-core.html)
* [Practitioner (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-practitioner-core.html)
* [Medical Device (CZ)(https://hl7.cz/fhir/core/StructureDefinition/cz-medical-device)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-medical-device.html)
* [Patient (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-patient-core.html)
* [Related Person (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-relatedPerson-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-relatedPerson-core.html)
* [Organization (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-organization-core.html)
* [Codeable Concept (IPS)(http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips)](http://hl7.org/fhir/uv/ips/STU1.1/StructureDefinition-CodeableConcept-uv-ips.html)
* [Encounter (HDR CZ)(https://hl7.cz/fhir/hdr/StructureDefinition/cz-encounter-hdr)](StructureDefinition-cz-encounter-hdr.md)
* [Condition (HDR CZ)(https://hl7.cz/fhir/hdr/StructureDefinition/cz-condition-hdr)](StructureDefinition-cz-condition-hdr.md)
* [Vital Signs Profile(http://hl7.org/fhir/StructureDefinition/vitalsigns)](http://hl7.org/fhir/R4/vitalsigns.html)
* [Allergy Intolerance (HDR CZ)(https://hl7.cz/fhir/hdr/StructureDefinition/cz-allergyIntolerance-hdr)](StructureDefinition-cz-allergyIntolerance-hdr.md)
* [Procedure (HDR CZ)(https://hl7.cz/fhir/hdr/StructureDefinition/cz-procedure-hdr)](StructureDefinition-cz-procedure-hdr.md)
* [DeviceUseStatement (HDR)(https://hl7.cz/fhir/hdr/StructureDefinition/cz-deviceUseStatement-hdr)](StructureDefinition-cz-deviceUseStatement-hdr.md)
* [MedicationDispense (HDR)(https://hl7.cz/fhir/hdr/StructureDefinition/cz-medicationDispense-hdr)](StructureDefinition-cz-medicationDispense-hdr.md)
* [Medication Statement (CZ)(https://hl7.cz/fhir/core/StructureDefinition/cz-MedicationStatement)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-MedicationStatement.html)
* [MedicationRequest (HDR CZ)(https://hl7.cz/fhir/hdr/StructureDefinition/cz-medicationRequest-hdr)](StructureDefinition-cz-medicationRequest-hdr.md)
* [Medication (CZ)(https://hl7.cz/fhir/core/StructureDefinition/cz-Medication)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-Medication.html)
* [Observation Laboratory (CZ)(https://hl7.cz/fhir/lab/StructureDefinition/cz-observation-result-laboratory)](https://build.fhir.org/ig/HL7-cz/cz-lab/StructureDefinition-cz-observation-result-laboratory.html)
* [Observation: Imaging Report (CZ)(https://hl7.cz/fhir/img/StructureDefinition/cz-observation-result-imaging)](https://build.fhir.org/ig/HL7-cz/img/StructureDefinition-cz-observation-result-imaging.html)
* [Condition (HDR)(http://hl7.eu/fhir/hdr/StructureDefinition/condition-eu-hdr)](http://hl7.eu/fhir/hdr/0.1.0-ballot/StructureDefinition-condition-eu-hdr.html)
* [Immunization (HDR CZ)(https://hl7.cz/fhir/hdr/StructureDefinition/cz-immunization-hdr)](StructureDefinition-cz-immunization-hdr.md)
* [ImmunizationRecommendation (HDR)(http://hl7.eu/fhir/hdr/StructureDefinition/immunizationRecommendation-eu-hdr)](http://hl7.eu/fhir/hdr/0.1.0-ballot/StructureDefinition-immunizationRecommendation-eu-hdr.html)
* [FamilyMemberHistory (HDR CZ)(https://hl7.cz/fhir/hdr/StructureDefinition/cz-familyMemberHistory-hdr)](StructureDefinition-cz-familyMemberHistory-hdr.md)
* [Condition (IPS)(http://hl7.org/fhir/uv/ips/StructureDefinition/Condition-uv-ips)](http://hl7.org/fhir/uv/ips/STU1.1/StructureDefinition-Condition-uv-ips.html)
* [Observation: SDOH (HDR CZ)(https://hl7.cz/fhir/hdr/StructureDefinition/cz-observation-sdoh-hdr)](StructureDefinition-cz-observation-sdoh-hdr.md)
* [Care Plan (HDR CZ)(https://hl7.cz/fhir/hdr/StructureDefinition/cz-carePlan-hdr)](StructureDefinition-cz-carePlan-hdr.md)
* [Coverage (CZ)(https://hl7.cz/fhir/core/StructureDefinition/cz-coverage)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-coverage.html)
* [Consent (Advance Directives) (HDR CZ)(https://hl7.cz/fhir/hdr/StructureDefinition/cz-consent-hdr)](StructureDefinition-cz-consent-hdr.md)
* [Observation: Infectious Contact (HDR CZ)(https://hl7.cz/fhir/hdr/StructureDefinition/cz-observation-infectious-contact-hdr)](StructureDefinition-cz-observation-infectious-contact-hdr.md)

**Extensions**

This structure refers to these extensions:

* [http://hl7.org/fhir/StructureDefinition/event-basedOn|5.2.0](http://hl7.org/fhir/extensions/5.2.0/StructureDefinition-event-basedOn.html)
* [http://hl7.eu/fhir/StructureDefinition/presentedForm|0.1.1-ci-build](https://build.fhir.org/ig/hl7-eu/extensions/StructureDefinition-presentedForm.html)
* [http://hl7.org/fhir/5.0/StructureDefinition/extension-Composition.version](http://hl7.org/fhir/R4/composition-definitions.html#Composition.version)
* [http://hl7.eu/fhir/StructureDefinition/information-recipient|0.5.0](https://build.fhir.org/ig/HL7-cz/cz-lab/StructureDefinition-information-recipient.html)

**Slices**

This structure defines the following [Slices](http://hl7.org/fhir/R4/profiling.html#slices):

* The element 1 is sliced based on the value of Composition.section
* The element 1 is sliced based on the value of Composition.section.section
* The element 1 is sliced based on the value of Composition.section.entry

 

Other representations of profile: [CSV](StructureDefinition-cz-composition-hdr.csv), [Excel](StructureDefinition-cz-composition-hdr.xlsx), [Schematron](StructureDefinition-cz-composition-hdr.sch) 

 IG © 2025+ [HL7 Czech Republic](https://www.hl7.cz/). Package hl7.fhir.cz.hdr#0.0.2 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

