# Care Plan (HDR CZ) - HL7 Czech Hospital Discharge Report Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Care Plan (HDR CZ)**

HL7 Czech Hospital Discharge Report Implementation Guide, published by HL7 Czech Republic. This guide is not an authorized publication; it is the continuous build for version 0.0.2 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7-cz/hdr/](https://github.com/HL7-cz/hdr/) and changes regularly. See the [Directory of published versions](https://hl7.cz/fhir/hdr/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-cz-carePlan-hdr-definitions.md) 
*  [Mappings](StructureDefinition-cz-carePlan-hdr-mappings.md) 
*  [XML](StructureDefinition-cz-carePlan-hdr.profile.xml.md) 
*  [JSON](StructureDefinition-cz-carePlan-hdr.profile.json.md) 
*  [TTL](StructureDefinition-cz-carePlan-hdr.profile.ttl.md) 

## Resource Profile: Care Plan (HDR CZ) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/StructureDefinition/cz-carePlan-hdr | *Version*:0.0.2 |
| Draft as of 2025-10-01 | *Computable Name*:CZ_CarePlanHdr |

 
This profile constrains the CarePlan resource for the purpose of this guide. 

**Usages:**

* Use this Profile: [Bundle (HDR CZ)](StructureDefinition-cz-bundle-hdr.md)
* Refer to this Profile: [Composition (HDR CZ)](StructureDefinition-cz-composition-hdr.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.hdr|current/StructureDefinition/cz-carePlan-hdr)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Terminology Bindings

#### Constraints

This structure is derived from [CarePlan](http://hl7.org/fhir/R4/careplan.html) 

#### Terminology Bindings

#### Constraints

This structure is derived from [CarePlan](http://hl7.org/fhir/R4/careplan.html) 

**Summary**

**Structures**

This structure refers to these other structures:

* [Condition (HDR CZ)(https://hl7.cz/fhir/hdr/StructureDefinition/cz-condition-hdr)](StructureDefinition-cz-condition-hdr.md)

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Differential View** 

This structure is derived from [CarePlan](http://hl7.org/fhir/R4/careplan.html) 

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [CarePlan](http://hl7.org/fhir/R4/careplan.html) 

**Summary**

**Structures**

This structure refers to these other structures:

* [Condition (HDR CZ)(https://hl7.cz/fhir/hdr/StructureDefinition/cz-condition-hdr)](StructureDefinition-cz-condition-hdr.md)

 

Other representations of profile: [CSV](StructureDefinition-cz-carePlan-hdr.csv), [Excel](StructureDefinition-cz-carePlan-hdr.xlsx), [Schematron](StructureDefinition-cz-carePlan-hdr.sch) 

 IG © 2025+ [HL7 Czech Republic](https://www.hl7.cz/). Package hl7.fhir.cz.hdr#0.0.2 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

