# Bundle (HDR CZ) - HL7 Czech Hospital Discharge Report Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Bundle (HDR CZ)**

HL7 Czech Hospital Discharge Report Implementation Guide, published by HL7 Czech Republic. This guide is not an authorized publication; it is the continuous build for version 0.0.2 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7-cz/hdr/](https://github.com/HL7-cz/hdr/) and changes regularly. See the [Directory of published versions](https://hl7.cz/fhir/hdr/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-cz-bundle-hdr-definitions.md) 
*  [Mappings](StructureDefinition-cz-bundle-hdr-mappings.md) 
*  [Examples](StructureDefinition-cz-bundle-hdr-examples.md) 
*  [XML](StructureDefinition-cz-bundle-hdr.profile.xml.md) 
*  [JSON](StructureDefinition-cz-bundle-hdr.profile.json.md) 
*  [TTL](StructureDefinition-cz-bundle-hdr.profile.ttl.md) 

## Resource Profile: Bundle (HDR CZ) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/StructureDefinition/cz-bundle-hdr | *Version*:0.0.2 |
| Draft as of 2025-10-01 | *Computable Name*:CZ_BundleHdr |

 
Clinical document used to represent a Hospital Discharge Report for the scope of this guide. 

### Content (cs)

#### Bundle (HDR CZ)

**Resource Bundle** představuje kompletní balíček všech zdrojů, které dohromady tvoří propouštěcí zprávu. Obsahuje jak hlavní dokumentovou kompozici (Composition), tak všechny související klinické a administrativní zdroje – například údaje o pacientovi, hospitalizační epizody, diagnózy, provedené výkony, výsledky vyšetření, medikaci, alergie, použité zdravotnické prostředky, pojištění a další.

Je určen pro přenos propouštěcí zprávy jako celku mezi systémy a zajišťuje konzistenci a úplnost dat.

* **Composition** – hlavička dokumentu, struktura a obsahové členění PZ.
* **Patient** – identifikace a základní údaje o pacientovi.
* **AllergyIntolerance** – záznamy o alergiích a intolerancích.
* **Condition** – diagnózy a zdravotní stavy pacienta.
* **Device & DeviceUseStatement** – použité zdravotnické prostředky a jejich aplikace.
* **DiagnosticReport, ImagingStudy, Observation, Specimen** – výsledky vyšetření, zobrazování a laboratorní nálezy.
* **Immunization** – provedená očkování.
* **Medication, MedicationRequest, MedicationStatement, MedicationDispense, MedicationAdministration** – předepsané, podané a vydané léky.
* **Encounter** – údaje o kontaktu pacienta se zdravotnickým zařízením.
* **Practitioner & PractitionerRole** – lékaři a ostatní zdravotničtí pracovníci, jejich role.
* **Organization** – organizace a zařízení podílející se na péči.
* **Procedure** – provedené zákroky a výkony.
* **FamilyMemberHistory** – relevantní rodinná anamnéza.
* **DocumentReference & Media** – připojené dokumenty a multimediální soubory.
* **Flag** – důležitá upozornění pro zdravotníky.
* **CarePlan & Goal** – plán péče a cíle léčby.
* **Consent** – dříve vyslovená přání.
* **Provenance** – informace o původu a autorství dat.
* **Coverage** – pojištění a úhradové údaje.
* **Signature** – digitální podpis balíčku.

#### Composition

Hlavní dokumentová struktura – obsahová osnova PZ: identifikace dokumentu, datum a čas vytvoření, autor a příjemce, členění do sekcí dle specifikace (např. Údaje o pacientovi, Diagnostický souhrn, Významné výkony, Výsledky vyšetření, Doporučení). Každá sekce obsahuje text a odkazy na podrobné zdroje.

#### Patient

Údaje o pacientovi: jméno, příjmení, rodné číslo / identifikátor pojištěnce, datum narození, pohlaví, adresa, kontakty, případně informace o zemřelém. Povinná část pro plnou identifikaci.

#### AllergyIntolerance

Záznamy o alergiích a intolerancích: látka nebo skupina látek, povaha reakce, závažnost a datum záznamu. Povinné u závažných reakcí, jinak možnost negativního záznamu.

#### Condition

Seznam diagnóz a zdravotních stavů: diagnóza při přijetí, hlavní propuštěcí diagnóza, komorbidity a komplikace, kódování dle ICD-10/SNOMED CT, časové určení. Vazba na sekce Diagnostický souhrn a Klinické shrnutí.

#### Device & DeviceUseStatement

Použité zdravotnické prostředky: implantáty, přístroje, pomůcky, identifikace výrobce, modelu, sériového čísla, doba použití a účel nasazení. Povinné při použití implantátu nebo významného prostředku.

#### DiagnosticReport, ImagingStudy, Observation, Specimen

Výsledky vyšetření a nálezů: laboratorní, zobrazovací a funkční vyšetření, indikace, metoda, datum, provádějící a interpretace. Specimen popisuje vzorky biologického materiálu.

#### Immunization

Záznamy o očkování provedeném během hospitalizace nebo relevantním pro aktuální stav: typ vakcíny, datum podání, výrobce, šarže a důvod podání.

#### Medication, MedicationRequest, MedicationStatement, MedicationDispense, MedicationAdministration

Kompletní přehled medikace: léky užívané před přijetím, předepsané při propuštění, podané během hospitalizace, vydané léky. Údaje o názvu, dávkování, cestě podání a době užívání. Odpovídá sekci Podstatná léčba.

#### Encounter

Údaje o kontaktu pacienta se zdravotnickým zařízením: datum a čas přijetí a propuštění, typ kontaktu, oddělení, účastníci péče, důvod hospitalizace, cílové umístění po propuštění. Vazba na sekce Průběh hospitalizace a Stav při propuštění.

#### Practitioner & PractitionerRole

Zdravotničtí pracovníci: identifikace lékařů a sester, role (ošetřující, konziliář, operatér), vazba na organizaci, ve které působí.

#### Organization

Zdravotnická zařízení: nemocnice, oddělení, ambulance, identifikátor, název, adresa, kontakty. Povinné pro hlavní poskytovatele v epizodě.

#### Procedure

Provedené zákroky a výkony: operace, invazivní výkony, významné intervence, datum, kód výkonu (např. CZ-DRG, ICHI). Vazba na sekci Významné výkony.

#### FamilyMemberHistory

Rodinná anamnéza: onemocnění příbuzných s možným vlivem na péči, diagnózy, vztah k pacientovi.

#### DocumentReference & Media

Připojené externí dokumenty a multimédia: starší lékařské zprávy, PDF nálezy, obrázky (rentgeny, fotodokumentace), odkazy na uložiště.

#### Flag

Důležitá upozornění: rizika (pád, infekce, agrese), speciální potřeby (tlumočník, dietní omezení).

#### CarePlan & Goal

Plán další péče a léčebné cíle: doporučení pro praktického lékaře nebo specialistu, rehabilitace, kontroly, plánovaná vyšetření. Vazba na sekci Doporučení.

#### Consent

záznamy o dříve vyslovených přáních pacienta, včetně údajů o typu, rozsahu a podmínkách jejich platnosti.

#### Provenance

Metadata o původu záznamů: kdo a kdy data vytvořil, změnil nebo schválil.

#### Coverage

Údaje o pojištění: pojišťovna, typ pojištění, identifikátor pojištěnce.

#### Signature

Digitální podpis: zajištění integrity a autenticity celé propouštěcí zprávy.

-------

**Usages:**

* Examples for this Profile: [Bundle/1c794aff-876a-41bf-9401-fa8fee3b1e57](Bundle-1c794aff-876a-41bf-9401-fa8fee3b1e57.md), [Bundle/DischargeBundle-Novak-Petr-L1-plus](Bundle-DischargeBundle-Novak-Petr-L1-plus.md), [Bundle/DischargeBundle-Novak-Petr-L1](Bundle-DischargeBundle-Novak-Petr-L1.md), [Bundle/DischargeBundle-Novak-Petr-Subsections](Bundle-DischargeBundle-Novak-Petr-Subsections.md) and [Bundle/DischargeBundle-Novak-Petr](Bundle-DischargeBundle-Novak-Petr.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.hdr|current/StructureDefinition/cz-bundle-hdr)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Terminology Bindings

#### Constraints

This structure is derived from [Bundle](http://hl7.org/fhir/R4/bundle.html) 

#### Constraints

#### Terminology Bindings

#### Constraints

This structure is derived from [Bundle](http://hl7.org/fhir/R4/bundle.html) 

**Summary**

Mandatory: 6 elements(1 nested mandatory element)
 Fixed: 1 element
 Prohibited: 5 elements

**Structures**

This structure refers to these other structures:

* [Composition (HDR CZ)(https://hl7.cz/fhir/hdr/StructureDefinition/cz-composition-hdr)](StructureDefinition-cz-composition-hdr.md)
* [Patient (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-patient-core.html)
* [Allergy Intolerance (HDR CZ)(https://hl7.cz/fhir/hdr/StructureDefinition/cz-allergyIntolerance-hdr)](StructureDefinition-cz-allergyIntolerance-hdr.md)
* [Condition (HDR CZ)(https://hl7.cz/fhir/hdr/StructureDefinition/cz-condition-hdr)](StructureDefinition-cz-condition-hdr.md)
* [Medical Device (CZ)(https://hl7.cz/fhir/core/StructureDefinition/cz-medical-device)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-medical-device.html)
* [DeviceUseStatement (HDR)(http://hl7.eu/fhir/hdr/StructureDefinition/deviceUseStatement-eu-hdr)](http://hl7.eu/fhir/hdr/0.1.0-ballot/StructureDefinition-deviceUseStatement-eu-hdr.html)
* [DiagnosticReport (IPS)(http://hl7.org/fhir/uv/ips/StructureDefinition/DiagnosticReport-uv-ips)](http://hl7.org/fhir/uv/ips/STU1.1/StructureDefinition-DiagnosticReport-uv-ips.html)
* [Encounter (HDR CZ)(https://hl7.cz/fhir/hdr/StructureDefinition/cz-encounter-hdr)](StructureDefinition-cz-encounter-hdr.md)
* [Imaging Study (IPS)(http://hl7.org/fhir/uv/ips/StructureDefinition/ImagingStudy-uv-ips)](http://hl7.org/fhir/uv/ips/STU1.1/StructureDefinition-ImagingStudy-uv-ips.html)
* [Immunization (IPS)(http://hl7.org/fhir/uv/ips/StructureDefinition/Immunization-uv-ips)](http://hl7.org/fhir/uv/ips/STU1.1/StructureDefinition-Immunization-uv-ips.html)
* [Medication (CZ)(https://hl7.cz/fhir/core/StructureDefinition/cz-Medication)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-Medication.html)
* [MedicationRequest (HDR CZ)(https://hl7.cz/fhir/hdr/StructureDefinition/cz-medicationRequest-hdr)](StructureDefinition-cz-medicationRequest-hdr.md)
* [Medication Statement (IPS)(http://hl7.org/fhir/uv/ips/StructureDefinition/MedicationStatement-uv-ips)](http://hl7.org/fhir/uv/ips/STU1.1/StructureDefinition-MedicationStatement-uv-ips.html)
* [Practitioner (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-practitioner-core.html)
* [Practitioner Role (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-practitionerrole-core.html)
* [Procedure (HDR CZ)(https://hl7.cz/fhir/hdr/StructureDefinition/cz-procedure-hdr)](StructureDefinition-cz-procedure-hdr.md)
* [Organization (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-organization-core.html)
* [Specimen (IPS)(http://hl7.org/fhir/uv/ips/StructureDefinition/Specimen-uv-ips)](http://hl7.org/fhir/uv/ips/STU1.1/StructureDefinition-Specimen-uv-ips.html)
* [Flag (HDR CZ)(https://hl7.cz/fhir/hdr/StructureDefinition/cz-flag-hdr)](StructureDefinition-cz-flag-hdr.md)
* [Care Plan (HDR CZ)(https://hl7.cz/fhir/hdr/StructureDefinition/cz-carePlan-hdr)](StructureDefinition-cz-carePlan-hdr.md)
* [Provenance (CZ)(https://hl7.cz/fhir/core/StructureDefinition/cz-provenance)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-provenance.html)
* [Coverage (CZ)(https://hl7.cz/fhir/core/StructureDefinition/cz-coverage)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-coverage.html)

**Slices**

This structure defines the following [Slices](http://hl7.org/fhir/R4/profiling.html#slices):

* The element 2 is sliced based on the values of Bundle.entry

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Differential View** 

This structure is derived from [Bundle](http://hl7.org/fhir/R4/bundle.html) 

#### Constraints

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [Bundle](http://hl7.org/fhir/R4/bundle.html) 

**Summary**

Mandatory: 6 elements(1 nested mandatory element)
 Fixed: 1 element
 Prohibited: 5 elements

**Structures**

This structure refers to these other structures:

* [Composition (HDR CZ)(https://hl7.cz/fhir/hdr/StructureDefinition/cz-composition-hdr)](StructureDefinition-cz-composition-hdr.md)
* [Patient (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-patient-core.html)
* [Allergy Intolerance (HDR CZ)(https://hl7.cz/fhir/hdr/StructureDefinition/cz-allergyIntolerance-hdr)](StructureDefinition-cz-allergyIntolerance-hdr.md)
* [Condition (HDR CZ)(https://hl7.cz/fhir/hdr/StructureDefinition/cz-condition-hdr)](StructureDefinition-cz-condition-hdr.md)
* [Medical Device (CZ)(https://hl7.cz/fhir/core/StructureDefinition/cz-medical-device)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-medical-device.html)
* [DeviceUseStatement (HDR)(http://hl7.eu/fhir/hdr/StructureDefinition/deviceUseStatement-eu-hdr)](http://hl7.eu/fhir/hdr/0.1.0-ballot/StructureDefinition-deviceUseStatement-eu-hdr.html)
* [DiagnosticReport (IPS)(http://hl7.org/fhir/uv/ips/StructureDefinition/DiagnosticReport-uv-ips)](http://hl7.org/fhir/uv/ips/STU1.1/StructureDefinition-DiagnosticReport-uv-ips.html)
* [Encounter (HDR CZ)(https://hl7.cz/fhir/hdr/StructureDefinition/cz-encounter-hdr)](StructureDefinition-cz-encounter-hdr.md)
* [Imaging Study (IPS)(http://hl7.org/fhir/uv/ips/StructureDefinition/ImagingStudy-uv-ips)](http://hl7.org/fhir/uv/ips/STU1.1/StructureDefinition-ImagingStudy-uv-ips.html)
* [Immunization (IPS)(http://hl7.org/fhir/uv/ips/StructureDefinition/Immunization-uv-ips)](http://hl7.org/fhir/uv/ips/STU1.1/StructureDefinition-Immunization-uv-ips.html)
* [Medication (CZ)(https://hl7.cz/fhir/core/StructureDefinition/cz-Medication)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-Medication.html)
* [MedicationRequest (HDR CZ)(https://hl7.cz/fhir/hdr/StructureDefinition/cz-medicationRequest-hdr)](StructureDefinition-cz-medicationRequest-hdr.md)
* [Medication Statement (IPS)(http://hl7.org/fhir/uv/ips/StructureDefinition/MedicationStatement-uv-ips)](http://hl7.org/fhir/uv/ips/STU1.1/StructureDefinition-MedicationStatement-uv-ips.html)
* [Practitioner (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-practitioner-core.html)
* [Practitioner Role (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-practitionerrole-core.html)
* [Procedure (HDR CZ)(https://hl7.cz/fhir/hdr/StructureDefinition/cz-procedure-hdr)](StructureDefinition-cz-procedure-hdr.md)
* [Organization (CZ core)(https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-organization-core.html)
* [Specimen (IPS)(http://hl7.org/fhir/uv/ips/StructureDefinition/Specimen-uv-ips)](http://hl7.org/fhir/uv/ips/STU1.1/StructureDefinition-Specimen-uv-ips.html)
* [Flag (HDR CZ)(https://hl7.cz/fhir/hdr/StructureDefinition/cz-flag-hdr)](StructureDefinition-cz-flag-hdr.md)
* [Care Plan (HDR CZ)(https://hl7.cz/fhir/hdr/StructureDefinition/cz-carePlan-hdr)](StructureDefinition-cz-carePlan-hdr.md)
* [Provenance (CZ)(https://hl7.cz/fhir/core/StructureDefinition/cz-provenance)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-provenance.html)
* [Coverage (CZ)(https://hl7.cz/fhir/core/StructureDefinition/cz-coverage)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-coverage.html)

**Slices**

This structure defines the following [Slices](http://hl7.org/fhir/R4/profiling.html#slices):

* The element 2 is sliced based on the values of Bundle.entry

 

Other representations of profile: [CSV](StructureDefinition-cz-bundle-hdr.csv), [Excel](StructureDefinition-cz-bundle-hdr.xlsx), [Schematron](StructureDefinition-cz-bundle-hdr.sch) 

 IG © 2025+ [HL7 Czech Republic](https://www.hl7.cz/). Package hl7.fhir.cz.hdr#0.0.2 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

