# Allergy Intolerance (HDR CZ) - HL7 Czech Hospital Discharge Report Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Allergy Intolerance (HDR CZ)**

HL7 Czech Hospital Discharge Report Implementation Guide, published by HL7 Czech Republic. This guide is not an authorized publication; it is the continuous build for version 0.0.2 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7-cz/hdr/](https://github.com/HL7-cz/hdr/) and changes regularly. See the [Directory of published versions](https://hl7.cz/fhir/hdr/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-cz-allergyIntolerance-hdr-definitions.md) 
*  [Mappings](StructureDefinition-cz-allergyIntolerance-hdr-mappings.md) 
*  [Examples](StructureDefinition-cz-allergyIntolerance-hdr-examples.md) 
*  [XML](StructureDefinition-cz-allergyIntolerance-hdr.profile.xml.md) 
*  [JSON](StructureDefinition-cz-allergyIntolerance-hdr.profile.json.md) 
*  [TTL](StructureDefinition-cz-allergyIntolerance-hdr.profile.ttl.md) 

## Resource Profile: Allergy Intolerance (HDR CZ) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/StructureDefinition/cz-allergyIntolerance-hdr | *Version*:0.0.2 | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:CZ_AllergyIntoleranceHdr |

 
This profile constrains the AllergyIntolerance resource for the purpose of this project. 

 
This profile constrains the AllergyIntolerance resource for the purpose of project. 

**Usages:**

* Derived from this Profile: [Allergy Intolerance Obligations (HDR CZ)](StructureDefinition-cz-allergyintolerance-obl-hdr.md)
* Use this Profile: [Bundle (HDR CZ)](StructureDefinition-cz-bundle-hdr.md)
* Refer to this Profile: [Composition (HDR CZ)](StructureDefinition-cz-composition-hdr.md)
* Examples for this Profile: [AllergyIntolerance/6cf80cb1-9766-470f-ac36-b1d3d8950f1b](AllergyIntolerance-6cf80cb1-9766-470f-ac36-b1d3d8950f1b.md), [AllergyIntolerance/AllergyInfoUnknown](AllergyIntolerance-AllergyInfoUnknown.md), [AllergyIntolerance/MilkAllergy](AllergyIntolerance-MilkAllergy.md), [AllergyIntolerance/NoKnownAllergy](AllergyIntolerance-NoKnownAllergy.md)...Show 2 more,[AllergyIntolerance/PenicillinAllergy](AllergyIntolerance-PenicillinAllergy.md)and[AllergyIntolerance/StrawberryAllergy](AllergyIntolerance-StrawberryAllergy.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.hdr|current/StructureDefinition/cz-allergyIntolerance-hdr)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Terminology Bindings

#### Constraints

This structure is derived from [CZ_AllergyIntolerance](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-allergyIntolerance.html) 

#### Terminology Bindings

#### Constraints

This structure is derived from [CZ_AllergyIntolerance](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-allergyIntolerance.html) 

**Summary**

Mandatory: 1 element

**Extensions**

This structure refers to these extensions:

* [http://hl7.org/fhir/StructureDefinition/allergyintolerance-abatement|5.2.0](http://hl7.org/fhir/extensions/5.2.0/StructureDefinition-allergyintolerance-abatement.html)

**Slices**

This structure defines the following [Slices](http://hl7.org/fhir/R4/profiling.html#slices):

* The element 1 is sliced based on the value of AllergyIntolerance.extension.value[x]

**[Maturity](http://hl7.org/fhir/versions.html#maturity)**: 1

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Differential View** 

This structure is derived from [CZ_AllergyIntolerance](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-allergyIntolerance.html) 

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [CZ_AllergyIntolerance](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-allergyIntolerance.html) 

**Summary**

Mandatory: 1 element

**Extensions**

This structure refers to these extensions:

* [http://hl7.org/fhir/StructureDefinition/allergyintolerance-abatement|5.2.0](http://hl7.org/fhir/extensions/5.2.0/StructureDefinition-allergyintolerance-abatement.html)

**Slices**

This structure defines the following [Slices](http://hl7.org/fhir/R4/profiling.html#slices):

* The element 1 is sliced based on the value of AllergyIntolerance.extension.value[x]

**[Maturity](http://hl7.org/fhir/versions.html#maturity)**: 1

 

Other representations of profile: [CSV](StructureDefinition-cz-allergyIntolerance-hdr.csv), [Excel](StructureDefinition-cz-allergyIntolerance-hdr.xlsx), [Schematron](StructureDefinition-cz-allergyIntolerance-hdr.sch) 

 IG © 2025+ [HL7 Czech Republic](https://www.hl7.cz/). Package hl7.fhir.cz.hdr#0.0.2 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

