# Allergy Intolerance (HDR CZ) - Examples - HL7 Czech Hospital Discharge Report Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Allergy Intolerance (HDR CZ)**

HL7 Czech Hospital Discharge Report Implementation Guide, published by HL7 Czech Republic. This guide is not an authorized publication; it is the continuous build for version 0.0.2 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7-cz/hdr/](https://github.com/HL7-cz/hdr/) and changes regularly. See the [Directory of published versions](https://hl7.cz/fhir/hdr/history.html)

*  [Content](StructureDefinition-cz-allergyIntolerance-hdr.md) 
*  [Detailed Descriptions](StructureDefinition-cz-allergyIntolerance-hdr-definitions.md) 
*  [Mappings](StructureDefinition-cz-allergyIntolerance-hdr-mappings.md) 
*  [Examples](#) 
*  [XML](StructureDefinition-cz-allergyIntolerance-hdr.profile.xml.md) 
*  [JSON](StructureDefinition-cz-allergyIntolerance-hdr.profile.json.md) 
*  [TTL](StructureDefinition-cz-allergyIntolerance-hdr.profile.ttl.md) 

## Resource Profile: CZ_AllergyIntoleranceHdr - Examples

| | |
| :--- | :--- |
| *Page standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 |

Examples for the cz-allergyIntolerance-hdr Profile.

| |
| :--- |
| [AllergyIntolerance - Strawberry](AllergyIntolerance-6cf80cb1-9766-470f-ac36-b1d3d8950f1b.md) |
| [Allergy Information Unknown](AllergyIntolerance-AllergyInfoUnknown.md) |
| [AllergyIntolerance - cow's milk protein](AllergyIntolerance-MilkAllergy.md) |
| [AllergyIntolerance - No Known Allergies](AllergyIntolerance-NoKnownAllergy.md) |
| [AllergyIntolerance - Penicillin](AllergyIntolerance-PenicillinAllergy.md) |
| [AllergyIntolerance - Strawberry](AllergyIntolerance-StrawberryAllergy.md) |

 IG © 2025+ [HL7 Czech Republic](https://www.hl7.cz/). Package hl7.fhir.cz.hdr#0.0.2 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

