# CZ-Procedure-HDR Example - Acute appendicitis - HL7 Czech Hospital Discharge Report Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CZ-Procedure-HDR Example - Acute appendicitis**

HL7 Czech Hospital Discharge Report Implementation Guide, published by HL7 Czech Republic. This guide is not an authorized publication; it is the continuous build for version 0.0.2 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7-cz/hdr/](https://github.com/HL7-cz/hdr/) and changes regularly. See the [Directory of published versions](https://hl7.cz/fhir/hdr/history.html)

*  [Narrative Content](#) 
*  [XML](Procedure-CZ-Procedure-HDR-Example-Acute-appendicitis.xml.md) 
*  [JSON](Procedure-CZ-Procedure-HDR-Example-Acute-appendicitis.json.md) 
*  [TTL](Procedure-CZ-Procedure-HDR-Example-Acute-appendicitis.ttl.md) 

## Example Procedure: CZ-Procedure-HDR Example - Acute appendicitis

Procedure: Apendektomie

Date: 2023-10-01T10:00:00Z

Reason: Akutní apendicitida

Complication: Peritonitida

Outcome: Částečně úspěšný

Text: Pacient byl přijat s akutní bolestí břicha, horečkou a známkami podráždění pobřišnice. Klinické vyšetření a zobrazovací metody potvrdily diagnózu akutní apendicitidy s generalizovanou peritonitidou (MKN-10: K35.2, K65.0). Byla provedena urgentní laparotomie, při které bylo odhaleno perforované apendix s difuzní hnisavou peritonitidou. Byla provedena apendektomie a následně peritoneální výplach a drenáž. Byla podána pooperační antibiotika. Pacient se momentálně zotavuje pod pečlivým dohledem.

 IG © 2025+ [HL7 Czech Republic](https://www.hl7.cz/). Package hl7.fhir.cz.hdr#0.0.2 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

