# PractitionerRole1 - HL7 Czech Hospital Discharge Report Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **PractitionerRole1**

HL7 Czech Hospital Discharge Report Implementation Guide, published by HL7 Czech Republic. This guide is not an authorized publication; it is the continuous build for version 0.0.2 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7-cz/hdr/](https://github.com/HL7-cz/hdr/) and changes regularly. See the [Directory of published versions](https://hl7.cz/fhir/hdr/history.html)

*  [Narrative Content](#) 
*  [XML](PractitionerRole-practitionerrole1.xml.md) 
*  [JSON](PractitionerRole-practitionerrole1.json.md) 
*  [TTL](PractitionerRole-practitionerrole1.ttl.md) 

## Example PractitionerRole: PractitionerRole1

version: 1; Last updated: 2019-07-01 13:30:55+0000

Profile: [Practitioner Role (CZ core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-practitionerrole-core.html)

**identifier**: `http://www.acme.org/practitioners`/23

**active**: true

**period**: 2022-08-01 00:00:00+0000 --> 2022-12-31 00:00:00+0000

**practitioner**: [MUDr. Stanislava Kubšová](Practitioner-Practitioner-2.md)

**organization**: [Ordinace praktického lékaře, MUDr. Stanislava Kubšová](https://build.fhir.org/ig/HL7-cz/cz-core/Organization-Organization-1.html)

**code**: Lékař

**specialty**: Family practice (qualifier value)

> **availableTime****daysOfWeek**: Tuesday, Wednesday**availableStartTime**: 12:30:00**availableEndTime**: 18:30:00

> **availableTime****daysOfWeek**: Thursday, Friday**availableStartTime**: 07:00:00**availableEndTime**: 13:00:00

### NotAvailables

| | | |
| :--- | :--- | :--- |
| - | **Description** | **During** |
| * | Plánovaná dovolená | 2023-08-01 00:00:00+0000 --> 2023-08-20 00:00:00+0000 |

**availabilityExceptions**: Státní svátky

 IG © 2025+ [HL7 Czech Republic](https://www.hl7.cz/). Package hl7.fhir.cz.hdr#0.0.2 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

