# Hemoglobin - HL7 Czech Hospital Discharge Report Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Hemoglobin**

HL7 Czech Hospital Discharge Report Implementation Guide, published by HL7 Czech Republic. This guide is not an authorized publication; it is the continuous build for version 0.0.2 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7-cz/hdr/](https://github.com/HL7-cz/hdr/) and changes regularly. See the [Directory of published versions](https://hl7.cz/fhir/hdr/history.html)

*  [Narrative Content](#) 
*  [XML](Observation-hb-result.xml.md) 
*  [JSON](Observation-hb-result.json.md) 
*  [TTL](Observation-hb-result.ttl.md) 

## Example Observation: Hemoglobin

**status**: Final

**code**: 11338

**subject**: [Mračena Mrakomorová Female, DoB: 1971-11-26 ( Passport number (use: official, ))](Patient-Mracena2.md)

**encounter**: [Encounter: status = finished; class = inpatient encounter (ActCode#IMP); priority = emergency; period = 2025-03-01 10:15:00+0100 --> 2025-03-10 09:30:00+0100](Encounter-10f5c49e-086d-4016-8dd1-b555306bf620.md)

**effective**: 2025-04-01 09:00:00+0100

**performer**: [Organization Hematologická laboratoř Brno](Organization-Lab-HematologieBrno.md)

**value**: 145 g/L(Details: UCUM codeg/L = 'g/L')

**interpretation**: Normal

**note**: 

> 

Hladina hemoglobinu je v normálním rozmezí.


**specimen**: [Specimen: status = available; type = Venous blood specimen; receivedTime = 2025-04-01 09:30:00+0100](Specimen-Specimen-EDTA-1.md)

### ReferenceRanges

| | | |
| :--- | :--- | :--- |
| - | **Low** | **High** |
| * | 135 g/L(Details: UCUM codeg/L = 'g/L') | 170 g/L(Details: UCUM codeg/L = 'g/L') |

 IG © 2025+ [HL7 Czech Republic](https://www.hl7.cz/). Package hl7.fhir.cz.hdr#0.0.2 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

