# ExampleChestCircumference - HL7 Czech Hospital Discharge Report Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **ExampleChestCircumference**

HL7 Czech Hospital Discharge Report Implementation Guide, published by HL7 Czech Republic. This guide is not an authorized publication; it is the continuous build for version 0.0.2 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7-cz/hdr/](https://github.com/HL7-cz/hdr/) and changes regularly. See the [Directory of published versions](https://hl7.cz/fhir/hdr/history.html)

*  [Narrative Content](#) 
*  [XML](Observation-4ba395b7-be9e-4bed-bef7-1c8f0b2d4e3a.xml.md) 
*  [JSON](Observation-4ba395b7-be9e-4bed-bef7-1c8f0b2d4e3a.json.md) 
*  [TTL](Observation-4ba395b7-be9e-4bed-bef7-1c8f0b2d4e3a.ttl.md) 

## Example Observation: ExampleChestCircumference

Profile: [Observation: Anthropometric Data (HDR CZ) - Chest Circumference](StructureDefinition-cz-observation-chestCircumference-hdr.md)

**status**: Final

**category**: Vital Signs

**code**: Waist Circumference at umbilicus by Tape measure

**subject**: [Petr Novák Male, DoB: 1985-06-15 ( https://ncez.mzcr.cz/fhir/sid/rid#1597778923)](Bundle-DischargeBundle-Novak-Petr-L1-plus.md#urn-uuid-3f85726c-ad2f-441b-89ce-100000000000)

**effective**: 2024-03-28

**performer**: [Practitioner Šárka Kašková](Practitioner-Practitioner-2.md)

**value**: 85 cm(Details: UCUM codecm = 'cm')

 IG © 2025+ [HL7 Czech Republic](https://www.hl7.cz/). Package hl7.fhir.cz.hdr#0.0.2 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

