# CZ-MedicationStatement-HDR Example of Ibalgin - HL7 Czech Hospital Discharge Report Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CZ-MedicationStatement-HDR Example of Ibalgin**

HL7 Czech Hospital Discharge Report Implementation Guide, published by HL7 Czech Republic. This guide is not an authorized publication; it is the continuous build for version 0.0.2 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7-cz/hdr/](https://github.com/HL7-cz/hdr/) and changes regularly. See the [Directory of published versions](https://hl7.cz/fhir/hdr/history.html)

*  [Narrative Content](#) 
*  [XML](MedicationStatement-bf08b62b-0abd-4e88-9092-ce0228382e51.xml.md) 
*  [JSON](MedicationStatement-bf08b62b-0abd-4e88-9092-ce0228382e51.json.md) 
*  [TTL](MedicationStatement-bf08b62b-0abd-4e88-9092-ce0228382e51.ttl.md) 

## Example MedicationStatement: CZ-MedicationStatement-HDR Example of Ibalgin

Profile: [Medication Statement (CZ)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-MedicationStatement.html)

**identifier**: `https://hl7.cz/fhir/core/CodeSystem/cz-dlplecivepripravky-cs`/0207893

**status**: Active

**statusReason**: Pokračuje

**category**: Inpatient

**medication**: [Medication IBALGIN](Medication-med-Ibalgin400.md)

**subject**: [Petr Novák Male, DoB: 1985-06-15 ( https://ncez.mzcr.cz/fhir/sid/rid#1597778923)](Bundle-DischargeBundle-Novak-Petr-L1-plus.md#urn-uuid-3f85726c-ad2f-441b-89ce-100000000000)

**effective**: 2025-03-01 10:15:00+0100 --> 2025-03-10 09:30:00+0100

**reasonCode**: Hypotyreóza

> **dosage****text**: Dle potřeby, při bolesti max 3 tablety denně**asNeeded**: true**route**:Oral use

### DoseAndRates

| | |
| :--- | :--- |
| - | **Dose[x]** |
| * | 400 mg |


 IG © 2025+ [HL7 Czech Republic](https://www.hl7.cz/). Package hl7.fhir.cz.hdr#0.0.2 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

