# Očkování Covid - HL7 Czech Hospital Discharge Report Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Očkování Covid**

HL7 Czech Hospital Discharge Report Implementation Guide, published by HL7 Czech Republic. This guide is not an authorized publication; it is the continuous build for version 0.0.2 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7-cz/hdr/](https://github.com/HL7-cz/hdr/) and changes regularly. See the [Directory of published versions](https://hl7.cz/fhir/hdr/history.html)

*  [Narrative Content](#) 
*  [XML](Immunization-Immunization-CovidExample.xml.md) 
*  [JSON](Immunization-Immunization-CovidExample.json.md) 
*  [TTL](Immunization-Immunization-CovidExample.ttl.md) 

## Example Immunization: Očkování Covid

Profile: [Immunization (HDR CZ)](StructureDefinition-cz-immunization-hdr.md)

> **Immunization AdministeredProduct**
* reference: [Medication COMIRNATY OMICRON XBB.1.5](Medication-med-CovidVaccineComirnaty.md)

**status**: Completed

**vaccineCode**: SARS-CoV-2 vaccine

**patient**: [Petr Novák Male, DoB: 1985-06-15 ( https://ncez.mzcr.cz/fhir/sid/rid#1597778923)](Patient-3f85726c-ad2f-441b-89ce-100000000000.md)

**occurrence**: 2021-05-05

**primarySource**: true

**manufacturer**: [Organization Pfizer s.r.o.](Organization-Organization-Pfizer.md)

**note**: 

> 

Pacient dostal druhou dávku vakcíny Comirnaty.


### ProtocolApplieds

| | | |
| :--- | :--- | :--- |
| - | **TargetDisease** | **DoseNumber[x]** |
| * | COVID-19 | 2 |

 IG © 2025+ [HL7 Czech Republic](https://www.hl7.cz/). Package hl7.fhir.cz.hdr#0.0.2 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

