# CZ-Encounter-HDR Example - HL7 Czech Hospital Discharge Report Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CZ-Encounter-HDR Example**

HL7 Czech Hospital Discharge Report Implementation Guide, published by HL7 Czech Republic. This guide is not an authorized publication; it is the continuous build for version 0.0.2 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7-cz/hdr/](https://github.com/HL7-cz/hdr/) and changes regularly. See the [Directory of published versions](https://hl7.cz/fhir/hdr/history.html)

*  [Narrative Content](#) 
*  [XML](Encounter-CZ-Encounter-HDR-Example.xml.md) 
*  [JSON](Encounter-CZ-Encounter-HDR-Example.json.md) 
*  [TTL](Encounter-CZ-Encounter-HDR-Example.ttl.md) 

## Example Encounter: CZ-Encounter-HDR Example

Profile: [Encounter (HDR CZ)](StructureDefinition-cz-encounter-hdr.md)

**org/fhir/StructureDefinition/legalStatus**: Legal

**status**: Finished

**class**: [ActCode IMP](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ActCode.html#v3-ActCode-IMP): inpatient encounter

**priority**: Emergency

**subject**: [Mračena Mrakomorová Female, DoB: 1971-11-26 ( Passport number (use: official, ))](Patient-Mracena2.md)

### Participants

| | | |
| :--- | :--- | :--- |
| - | **Type** | **Individual** |
| * | Admitter | [Practitioner Šárka Kašková](Practitioner-Practitioner-2.md) |

**period**: 2025-01-01 08:00:00+0100 --> 2025-01-10 08:00:00+0100

**reasonCode**: Heart failure

### Diagnoses

| | | |
| :--- | :--- | :--- |
| - | **Condition** | **Use** |
| * | [Condition Heart failure](Condition-CZ-Condition-HDR-Example.md) | Admission diagnosis |

### Hospitalizations

| | | |
| :--- | :--- | :--- |
| - | **AdmitSource** | **DischargeDisposition** |
| * | Medical Practitioner/physician referral | Home |

> **location****location**:[Location Nemocnice Praha - Oddělení A](Location-sample-cz-location-2.md)**period**: 2025-01-01 08:00:00+0100 --> 2025-01-03 08:00:00+0100

> **location****location**:[Location Nemocnice Praha - Oddělení B](Location-sample-cz-location-3.md)**period**: 2025-01-03 08:00:00+0100 --> 2025-01-07 08:00:00+0100

> **location****location**:[Location Nemocnice Praha - Oddělení C](Location-sample-cz-location-4.md)**period**: 2025-01-07 08:00:00+0100 --> 2025-01-10 08:00:00+0100

**serviceProvider**: [Organization MUDr. Jana Krásná](Organization-RegisteringProviderExample.md)

 IG © 2025+ [HL7 Czech Republic](https://www.hl7.cz/). Package hl7.fhir.cz.hdr#0.0.2 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

