# CZ-Encounter-HDR Example of encounter with emergency priority - HL7 Czech Hospital Discharge Report Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CZ-Encounter-HDR Example of encounter with emergency priority**

HL7 Czech Hospital Discharge Report Implementation Guide, published by HL7 Czech Republic. This guide is not an authorized publication; it is the continuous build for version 0.0.2 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7-cz/hdr/](https://github.com/HL7-cz/hdr/) and changes regularly. See the [Directory of published versions](https://hl7.cz/fhir/hdr/history.html)

*  [Narrative Content](#) 
*  [XML](Encounter-10f5c49e-086d-4016-8dd1-b555306bf620.xml.md) 
*  [JSON](Encounter-10f5c49e-086d-4016-8dd1-b555306bf620.json.md) 
*  [TTL](Encounter-10f5c49e-086d-4016-8dd1-b555306bf620.ttl.md) 

## Example Encounter: CZ-Encounter-HDR Example of encounter with emergency priority

Profile: [Encounter (HDR CZ)](StructureDefinition-cz-encounter-hdr.md)

**status**: Finished

**class**: [ActCode IMP](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ActCode.html#v3-ActCode-IMP): inpatient encounter

**priority**: emergency

**subject**: [Petr Novák Male, DoB: 1985-06-15 ( https://ncez.mzcr.cz/fhir/sid/rid#1597778923)](Bundle-DischargeBundle-Novak-Petr-L1-plus.md#urn-uuid-3f85726c-ad2f-441b-89ce-100000000000)

> **participant****type**:Admitter**individual**:[Practitioner MUDr. Karel Volný](Practitioner-Practitioner-Admitter.md)

> **participant****type**:Referrer**individual**:[PractitionerRole Lékař](PractitionerRole-Practitioner-Referrer-detail.md)

**period**: 2025-03-01 10:15:00+0100 --> 2025-03-10 09:30:00+0100

**reasonReference**: [Condition Unilateral or unspecified inguinal hernia, without obstruction or gangrene](Bundle-DischargeBundle-Novak-Petr-Subsections.md#urn-uuid-35717696-8a99-4f99-a938-ec0ec88a65a2)

### Hospitalizations

| | | |
| :--- | :--- | :--- |
| - | **AdmitSource** | **DischargeDisposition** |
| * | From outpatient department | Home |

> **location****location**:[Location Nemocnice Chrudim - Oddělení CHIR1](Location-cz-Location-Chrudim-Chir1.md)**period**: 2025-03-01 08:00:00+0100 --> 2025-03-02 08:00:00+0100

> **location****location**:[Location Nemocnice Chrudim - Oddělení CHIR-JIP](Location-cz-Location-Chrudim-ChirJIP.md)**period**: 2025-03-02 08:00:00+0100 --> 2025-03-04 08:00:00+0100

> **location****location**:[Location Nemocnice Chrudim - Oddělení CHIR1](Location-cz-Location-Chrudim-Chir1.md)**period**: 2025-03-04 08:00:00+0100 --> 2025-03-10 08:00:00+0100

**serviceProvider**: [Organization MUDr. Jana Krásná](Organization-RegisteringProviderExample.md)

 IG © 2025+ [HL7 Czech Republic](https://www.hl7.cz/). Package hl7.fhir.cz.hdr#0.0.2 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

