# eHN Subject Model to this guide Map - HL7 Czech Hospital Discharge Report Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **eHN Subject Model to this guide Map**

HL7 Czech Hospital Discharge Report Implementation Guide, published by HL7 Czech Republic. This guide is not an authorized publication; it is the continuous build for version 0.0.2 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7-cz/hdr/](https://github.com/HL7-cz/hdr/) and changes regularly. See the [Directory of published versions](https://hl7.cz/fhir/hdr/history.html)

*  [Narrative Content](#) 
*  [XML](ConceptMap-subject2FHIR-cz-hdr.xml.md) 
*  [JSON](ConceptMap-subject2FHIR-cz-hdr.json.md) 
*  [TTL](ConceptMap-subject2FHIR-cz-hdr.ttl.md) 

## ConceptMap: eHN Subject Model to this guide Map (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/ConceptMap/subject2FHIR-cz-hdr | *Version*:0.0.2 |
| Draft as of 2025-10-01 | *Computable Name*:Subject2FHIRCzHdr |

 
eHN HDR Subject Model to this guide mapping 

Mapping from (not specified) to (not specified)

**Group 1**Mapping from [A.1.1 - Identification and A.1.2 - related contact information of the Patient/subject](StructureDefinition-SubjectCz.md) to [Patient (CZ core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-patient-core.html)

* **Source Code**: subjectIdentification (A.1.1 - Identification of the patient/subject)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Patient
* **Source Code**: subjectIdentification.given (A.1.1.1 - Given name)
  * **Relationship**: [is equal to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equal)
  * **Target Code**: Patient.name.given
* **Source Code**: subjectIdentification.family (A.1.1.2 - Family name/surname)
  * **Relationship**: [is equal to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equal)
  * **Target Code**: Patient.name.family
* **Source Code**: subjectIdentification.birthDate (A.1.1.3 - Date of birth)
  * **Relationship**: [is equal to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equal)
  * **Target Code**: Patient.birthDate
* **Source Code**: subjectIdentification.identifier (A.1.1.4 - National healthcare patient ID)
  * **Relationship**: [is equal to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equal)
  * **Target Code**: Patient.identifier
* **Source Code**: subjectIdentification.Citizenship (A.1.1.5 - Citizenship)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Patient.extension:Citizenship.valueCodeableConcept
* **Source Code**: subjectIdentification.gender (A.1.1.6 - Gender)
  * **Relationship**: [is equal to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equal)
  * **Target Code**: Patient.gender
* **Source Code**: subjectIdentification.Communication (A.1.1.7 - Communication - Language)
  * **Relationship**: [is equal to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equal)
  * **Target Code**: Patient.Communication
* **Source Code**: subjectContact (A.1.2 - Patient/subject related contact information)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Patient
* **Source Code**: subjectContact.personalContact (A.1.2.1 - Patient address)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Patient
* **Source Code**: subjectContact.personalContact.address (A.1.2.1.1 - Address)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Patient.address
* **Source Code**: subjectContact.personalContact.telecom (A.1.2.1.2 - Telecom)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Patient.telecom
* **Source Code**: subjectContact.preferredHP (A.1.2.2 - Preferred health professional (HP) - This section can be repeated and linked to any specific information in the document, for example a link between a rare disease problem and the rare disease specialist responsible for the care of the individual patient (this section).)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Patient.generalPractitioner
* **Source Code**: subjectContact.contactPerson (A.1.2.3 - Contact person/ legal guardian (multiple contacts could be provided))
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Patient.contact
* **Source Code**: subjectContact.contactPerson.role (A.1.2.3.1 - Role of that person)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Patient.contact.relationship:role
* **Source Code**: subjectContact.contactPerson.relationship (A.1.2.3.2 - Relationship level)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Patient.contact.relationship:type
* **Source Code**: subjectContact.contactPerson.given (A.1.2.3.4 - Given name)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Patient.contact.name.given
* **Source Code**: subjectContact.contactPerson.family (A.1.2.3.5 - Family name/surname)
  * **Relationship**: [is equal to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equal)
  * **Target Code**: Patient.contact.name.family
* **Source Code**: subjectContact.contactPerson.address (A.1.2.3.6 - Address)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Patient.contact.address
* **Source Code**: subjectContact.contactPerson.telecom (A.1.2.3.7 - Telecom)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Patient.contact.telecom
* **Source Code**: subjectContact.contactPerson.organization (A.1.2.3.8 - Contact person organisation)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Patient.contact

-------

**Group 2**Mapping from [A.1.1 - Identification and A.1.2 - related contact information of the Patient/subject](StructureDefinition-SubjectCz.md) to [Practitioner (CZ core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-practitioner-core.html)

* **Source Code**: subjectContact.preferredHP (A.1.2.2 - Preferred health professional (HP) - This section can be repeated and linked to any specific information in the document, for example a link between a rare disease problem and the rare disease specialist responsible for the care of the individual patient (this section).)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Practictioner
* **Source Code**: subjectContact.preferredHP.identifier (A.1.2.2.1 - Identifier of the HP)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Practictioner.identifier
* **Source Code**: subjectContact.preferredHP.name (A.1.2.2.2 - Name of the HP)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Practictioner.name
* **Source Code**: subjectContact.preferredHP.address (A.1.2.2.5 - Address)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Practictioner.address
* **Source Code**: subjectContact.preferredHP.telecom (A.1.2.2.6 - Telecom)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Practictioner.telecom

-------

**Group 3**Mapping from [A.1.1 - Identification and A.1.2 - related contact information of the Patient/subject](StructureDefinition-SubjectCz.md) to [Practitioner Role (CZ core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-practitionerrole-core.html)

* **Source Code**: subjectContact.preferredHP (A.1.2.2 - Preferred health professional (HP) - This section can be repeated and linked to any specific information in the document, for example a link between a rare disease problem and the rare disease specialist responsible for the care of the individual patient (this section).)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: PractictionerRole
  * **Comment**: preferred
* **Source Code**: subjectContact.preferredHP.identifier (A.1.2.2.1 - Identifier of the HP)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: PractictionerRole.identifier
  * **Comment**: preferred
* **Source Code**: subjectContact.preferredHP.name (A.1.2.2.2 - Name of the HP)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: PractictionerRole.practictioner.name
  * **Comment**: preferred
* **Source Code**: subjectContact.preferredHP.role (A.1.2.2.3 - Role of the HP)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: PractictionerRole.code
  * **Comment**: 
* **Source Code**: subjectContact.preferredHP.organization (A.1.2.2.4 - HP Organisation)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: PractictionerRole.organization
  * **Comment**: 
* **Source Code**: subjectContact.preferredHP.address (A.1.2.2.5 - Address)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: PractictionerRole.address
  * **Comment**: preferred
* **Source Code**: subjectContact.preferredHP.telecom (A.1.2.2.6 - Telecom)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: PractictionerRole.telecom
  * **Comment**: preferred

 IG © 2025+ [HL7 Czech Republic](https://www.hl7.cz/). Package hl7.fhir.cz.hdr#0.0.2 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

