# eHN Plan of Care Model to this guide Map - HL7 Czech Hospital Discharge Report Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **eHN Plan of Care Model to this guide Map**

HL7 Czech Hospital Discharge Report Implementation Guide, published by HL7 Czech Republic. This guide is not an authorized publication; it is the continuous build for version 0.0.2 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7-cz/hdr/](https://github.com/HL7-cz/hdr/) and changes regularly. See the [Directory of published versions](https://hl7.cz/fhir/hdr/history.html)

*  [Narrative Content](#) 
*  [XML](ConceptMap-planOfCare2FHIR-cz-hdr.xml.md) 
*  [JSON](ConceptMap-planOfCare2FHIR-cz-hdr.json.md) 
*  [TTL](ConceptMap-planOfCare2FHIR-cz-hdr.ttl.md) 

## ConceptMap: eHN Plan of Care Model to this guide Map (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/ConceptMap/planOfCare2FHIR-cz-hdr | *Version*:0.0.2 |
| Draft as of 2025-10-01 | *Computable Name*:PlanOfCare2FHIRCzHdr |

 
eHN HDR Plan of Care Model to this guide Map 

Mapping from (not specified) to (not specified)

**Group 1**Mapping from [A.2.8.1 - Care plan](StructureDefinition-PlanOfCareCz.md) to [Care Plan (HDR CZ)](StructureDefinition-cz-carePlan-hdr.md)

* **Source Code**: PlanOfCare.title (A.2.9.1.1 - Title)
  * **Relationship**: [is equal to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equal)
  * **Target Code**: CarePlan.title
* **Source Code**: PlanOfCare.addresses (A.2.9.1.2 - Addresses)
  * **Relationship**: [is equal to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equal)
  * **Target Code**: CarePlan.addresses
* **Source Code**: PlanOfCare.description (A.2.9.1.3 - Description)
  * **Relationship**: [is equal to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equal)
  * **Target Code**: CarePlan.description
* **Source Code**: PlanOfCare.planPeriod (A.2.9.1.4 - Plan Period)
  * **Relationship**: [is equal to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equal)
  * **Target Code**: CarePlan.period
* **Source Code**: PlanOfCare.details (A.2.9.1.5 - Other details)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: CarePlan.activity.detail
* **Source Code**: PlanOfCare.activity (A.2.9.1.6 - Activity)
  * **Relationship**: [is equal to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equal)
  * **Target Code**: CarePlan.activity
* **Source Code**: PlanOfCare.activity.kind (A.2.9.1.6.1 - Kind)
  * **Relationship**: [is equal to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equal)
  * **Target Code**: CarePlan.activity.detail.kind
* **Source Code**: PlanOfCare.activity.description (A.2.9.1.6.2 - Activity description)
  * **Relationship**: [is equal to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equal)
  * **Target Code**: CarePlan.detail.description
* **Source Code**: PlanOfCare.activity.attribute (A.2.9.1.6.3 - Specific attributes)
  * **Relationship**: [is equal to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equal)
  * **Target Code**: CarePlan.activity.reference

 IG © 2025+ [HL7 Czech Republic](https://www.hl7.cz/). Package hl7.fhir.cz.hdr#0.0.2 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

