# CZ Patient History to this guide Map - HL7 Czech Hospital Discharge Report Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CZ Patient History to this guide Map**

HL7 Czech Hospital Discharge Report Implementation Guide, published by HL7 Czech Republic. This guide is not an authorized publication; it is the continuous build for version 0.0.2 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7-cz/hdr/](https://github.com/HL7-cz/hdr/) and changes regularly. See the [Directory of published versions](https://hl7.cz/fhir/hdr/history.html)

*  [Narrative Content](#) 
*  [XML](ConceptMap-patientHistory2FHIR-cz-hdr.xml.md) 
*  [JSON](ConceptMap-patientHistory2FHIR-cz-hdr.json.md) 
*  [TTL](ConceptMap-patientHistory2FHIR-cz-hdr.ttl.md) 

## ConceptMap: CZ Patient History to this guide Map (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/ConceptMap/patientHistory2FHIR-cz-hdr | *Version*:0.0.2 |
| Draft as of 2025-10-01 | *Computable Name*:PatientHistory2FHIRCzHdr |

 
CZ HDR Patient History Model to this guide Map 

Mapping from (not specified) to (not specified)

**Group 1**Mapping from [A.2.5 - Patient history (eHN)](StructureDefinition-PatientHistoryCz.md) to [ImmunizationRecommendation (CZ HDR)](StructureDefinition-cz-immunizationRecommendation-hdr.md)

* **Source Code**: PatientHistory.medicalHistory.vaccination.nextVaccinationDate (A.2.6.1.4.8 - Next vaccination date)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: ImmunizationRecommendation.recommendation.dateCriterion[nextDose].value

-------

**Group 2**Mapping from [A.2.5 - Patient history (eHN)](StructureDefinition-PatientHistoryCz.md) to [Composition (HDR CZ)](StructureDefinition-cz-composition-hdr.md)

* **Source Code**: PatientHistory.medicalHistory (A.2.6.1 - Medical history)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composiiton.section
  * **Comment**: several sections
* **Source Code**: PatientHistory.medicalHistory.historyOfConditions (A.2.6.1.1 - History of problems)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composiiton.section:sectionDiagnosticSummary
  * **Comment**: The same section used by the hospital stay ?
* **Source Code**: PatientHistory.medicalHistory.historyOfConditions.resolution (A.2.6.1.1.6 - Resolution circumstances)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:sectionDiagnosticSummary.text
  * **Comment**: The resolution circumstances may be described as resource or composiiton.section text ; or indirectly determined by the resource (e.g. Procedure) that has been perfomed in reason of this Condition no more active
* **Source Code**: PatientHistory.medicalHistory.medicalDevices (A.2.6.1.2 - Devices and Implants)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:sectionMedicalDevices
  * **Comment**: 
* **Source Code**: PatientHistory.medicalHistory.vaccination (A.2.6.1.4 - Vaccination)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Composition.section:sectionImmunizations
  * **Comment**: 
* **Source Code**: PatientHistory.medicalHistory.epidemiologicalHistory (A.2.6.1.5 - Epidemiological history)
  * **Relationship**: (not mapped)
  * **Target Code**: decison not to have as distict section
* **Source Code**: PatientHistory.medicalHistory.epidemiologicalHistory.infectiousContacts (A.2.6.1.5.1 - Infectious contacts)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:infectiousContacts
  * **Comment**: 
* **Source Code**: PatientHistory.medicalHistory.epidemiologicalHistory.travelHistory (A.2.6.1.5.2 - Travel history)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:sectionTravelHx
  * **Comment**: 
* **Source Code**: PatientHistory.medicalHistory.epidemiologicalHistory.travelHistory.period (A.2.6.1.5.2.1 - Time period)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:sectionTravelHx
  * **Comment**: To be specified
* **Source Code**: PatientHistory.medicalHistory.epidemiologicalHistory.travelHistory.country (A.2.6.1.5.2.2 - Country visited)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:sectionTravelHx
  * **Comment**: To be specified
* **Source Code**: PatientHistory.medicalHistory.epidemiologicalHistory.travelHistory.comment (A.2.6.1.5.2.3 - Comment)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:sectionTravelHx
  * **Comment**: To be specified
* **Source Code**: PatientHistory.familyHistory (A.2.6.2 - Family history)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:sectionFamilyHistory
  * **Comment**: 
* **Source Code**: PatientHistory.socialDeterminants (A.2.6.3 - Social determinants of health)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:sectionSocialHistory
  * **Comment**: 
* **Source Code**: PatientHistory.useOfSubstances (A.2.6.4 - Use of substances)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:sectionSocialHistory
  * **Comment**: To be specified

-------

**Group 3**Mapping from [A.2.5 - Patient history (eHN)](StructureDefinition-PatientHistoryCz.md) to [Condition (HDR CZ)](StructureDefinition-cz-condition-hdr.md)

* **Source Code**: PatientHistory.medicalHistory.historyOfConditions.conditionSpecification (A.2.6.1.1.1 - Problem description)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Condition.text
  * **Comment**: 
* **Source Code**: PatientHistory.medicalHistory.historyOfConditions.conditionDetails (A.2.6.1.1.2 - Problem details)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Condition
  * **Comment**: 
* **Source Code**: PatientHistory.medicalHistory.historyOfConditions.onsetDate (A.2.6.1.1.3 - Onset date)
  * **Relationship**: [is equal to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equal)
  * **Target Code**: Condition.onSetDateTime
  * **Comment**: 
* **Source Code**: PatientHistory.medicalHistory.historyOfConditions.endDate (A.2.6.1.1.4 - End date)
  * **Relationship**: [is equal to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equal)
  * **Target Code**: Condition.abatementDateTime
  * **Comment**: 
* **Source Code**: PatientHistory.medicalHistory.historyOfConditions.clinicalStatus (A.2.6.1.1.5 - Clinical status)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Composition.clinicalStatus
  * **Comment**: 
* **Source Code**: PatientHistory.medicalHistory.historyOfConditions.resolution (A.2.6.1.1.6 - Resolution circumstances)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Condition.text
  * **Comment**: The resolution circumstances may be described as resource or composiiton.section text ; or indirectly determined by the resource (e.g. Procedure) that has been perfomed in reason of this Condition no more active
* **Source Code**: PatientHistory.medicalHistory.historyOfConditions.severity (A.2.6.1.1.7 - Severity)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.severity
  * **Comment**: 
* **Source Code**: PatientHistory.medicalHistory.historyOfConditions.stage (A.2.6.1.1.8 - Stage)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Composition.stage
  * **Comment**: 

-------

**Group 4**Mapping from [A.2.5 - Patient history (eHN)](StructureDefinition-PatientHistoryCz.md) to [Medical Device (CZ)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-medical-device.html)

* **Source Code**: PatientHistory.medicalHistory.medicalDevices.description (A.2.6.1.2.1 - Device and implant description)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Device.text
  * **Comment**: if referring to the description of the device
* **Source Code**: PatientHistory.medicalHistory.medicalDevices.identifier (A.2.6.1.2.2 - Device ID)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Device.identifier
  * **Comment**: if generic identifier
* **Source Code**: PatientHistory.medicalHistory.medicalDevices.identifier (A.2.6.1.2.2 - Device ID)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Device.udiCarrier
  * **Comment**: if it is the udiCarrier

-------

**Group 5**Mapping from [A.2.5 - Patient history (eHN)](StructureDefinition-PatientHistoryCz.md) to [DeviceUseStatement](http://hl7.org/fhir/R4/deviceusestatement.html)

* **Source Code**: PatientHistory.medicalHistory.medicalDevices.description (A.2.6.1.2.1 - Device and implant description)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: DeviceUseStatement.text
  * **Comment**: if referring to the description of the usage of the device
* **Source Code**: PatientHistory.medicalHistory.medicalDevices.implantDate (A.2.6.1.2.3 - Implant date)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: DeviceUseStatement.timing[x]
  * **Comment**: If the usage period is highlighted
* **Source Code**: PatientHistory.medicalHistory.medicalDevices.endDate (A.2.6.1.2.4 - End date)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: DeviceUseStatement.timingPeriod.end
  * **Comment**: 
* **Source Code**: PatientHistory.medicalHistory.medicalDevices.reason (A.2.6.1.2.5 - Reason)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: DeviceUseStatement.reasonCode
  * **Comment**: if details about the body structure have to be provided
* **Source Code**: PatientHistory.medicalHistory.medicalDevices.reason (A.2.6.1.2.5 - Reason)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: DeviceUseStatement.reasonReference
  * **Comment**: 
* **Source Code**: PatientHistory.medicalHistory.historyOfProcedures (A.2.6.1.3 - History of procedures)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:sectionSignificantProcedures
  * **Comment**: The same section usd by the hospital stay ?

-------

**Group 6**Mapping from [A.2.5 - Patient history (eHN)](StructureDefinition-PatientHistoryCz.md) to [Immunization (HDR CZ)](StructureDefinition-cz-immunization-hdr.md)

* **Source Code**: PatientHistory.medicalHistory.vaccination.diseaseOrAgent (A.2.6.1.4.1 - Disease or agent targeted)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Immunization.protocolApplied.targetDisease
* **Source Code**: PatientHistory.medicalHistory.vaccination.vaccine (A.2.6.1.4.2 - Vaccine/prophylaxis)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Immunization.vaccineCode
* **Source Code**: PatientHistory.medicalHistory.vaccination.productName (A.2.6.1.4.4 - Vaccine medicinal product)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Immunization.extension:administeredProduct
* **Source Code**: PatientHistory.medicalHistory.vaccination.manufacturerOrMAH (A.2.6.1.4.5 - Marketing Authorisation Holder)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Immunization.manufacturer
* **Source Code**: PatientHistory.medicalHistory.vaccination.orderNumber (A.2.6.1.4.6 - Number in a series of vaccinations / doses)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Immunization.protocolApplied.doseNumberPositiveInt
* **Source Code**: PatientHistory.medicalHistory.vaccination.vaccinationDate (A.2.6.1.4.7 - Date of vaccination)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Immunization.occurenceDateTime

-------

**Group 7**Mapping from [A.2.5 - Patient history (eHN)](StructureDefinition-PatientHistoryCz.md) to [Observation: SDOH (HDR CZ)](StructureDefinition-cz-observation-sdoh-hdr.md)

* **Source Code**: PatientHistory.socialDeterminants.participationInSociety (A.2.6.3.1 - Participation in society)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Observation
  * **Comment**: category to be defined
* **Source Code**: PatientHistory.socialDeterminants.participationInSociety.workSituation (A.2.6.3.1.1 - Work situation)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Observation.value[x]
  * **Comment**: category and code to be defined
* **Source Code**: PatientHistory.socialDeterminants.participationInSociety.hobby (A.2.6.3.1.2 - Hobby)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Observation.value[x]
  * **Comment**: category and code to be defined
* **Source Code**: PatientHistory.socialDeterminants.participationInSociety.socailNetwork (A.2.6.3.1.3 - Social network)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Observation.value[x]
  * **Comment**: category and code to be defined
* **Source Code**: PatientHistory.socialDeterminants.education (A.2.6.3.2 - Education)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Observation
  * **Comment**: category to be defined
* **Source Code**: PatientHistory.socialDeterminants.education.level (A.2.6.3.2.1 - Education level)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Observation.value[x]
  * **Comment**: category and code to be defined
* **Source Code**: PatientHistory.socialDeterminants.education.comment (A.2.6.3.2.2 - Comment)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Observation.note
  * **Comment**: category and code to be defined
* **Source Code**: PatientHistory.socialDeterminants.livingSituation (A.2.6.3.3 - Living situation)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Observation
  * **Comment**: category to be defined
* **Source Code**: PatientHistory.socialDeterminants.livingSituation.houseType (A.2.6.3.3.1 - House type)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Observation.value[x]
  * **Comment**: category and code to be defined
* **Source Code**: PatientHistory.socialDeterminants.livingSituation.homeAdaption (A.2.6.3.3.2 - Home adaption)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Observation.value[x]
  * **Comment**: category and code to be defined
* **Source Code**: PatientHistory.socialDeterminants.livingSituation.livingConditions (A.2.6.3.3.3 - Living conditions)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Observation.value[x]
  * **Comment**: category and code to be defined
* **Source Code**: PatientHistory.socialDeterminants.familySituation (A.2.6.3.4 - Family situation)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Observation
  * **Comment**: category to be defined
* **Source Code**: PatientHistory.socialDeterminants.familySituation.comment (A.2.6.3.4.1 - Comment)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Observation.value[x]
  * **Comment**: category and code to be defined
* **Source Code**: PatientHistory.socialDeterminants.familySituation.familyComposition (A.2.6.3.4.2 - Family composition)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Observation.value[x]
  * **Comment**: category and code to be defined
* **Source Code**: PatientHistory.socialDeterminants.familySituation.maritalStatus (A.2.6.3.4.3 - Marital status)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Observation.value[x]
  * **Comment**: category and code to be defined
* **Source Code**: PatientHistory.socialDeterminants.familySituation.numberOfChildren (A.2.6.3.4.4 - Number of children)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Observation.value[x]
  * **Comment**: category and code to be defined
* **Source Code**: PatientHistory.socialDeterminants.familySituation.numberOfChildrenAtHome (A.2.6.3.4.5 - Number of children at home)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Observation.value[x]
  * **Comment**: category and code to be defined
* **Source Code**: PatientHistory.socialDeterminants.familySituation.childDetails (A.2.6.3.4.6 - Child details)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Observation.value[x]
  * **Comment**: category and code to be defined
* **Source Code**: PatientHistory.socialDeterminants.familySituation.careResponsibility (A.2.6.3.4.7 - Care responsibility)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Observation.value[x]
  * **Comment**: category and code to be defined

-------

**Group 8**Mapping from [A.2.5 - Patient history (eHN)](StructureDefinition-PatientHistoryCz.md) to [Procedure (HDR CZ)](StructureDefinition-cz-procedure-hdr.md)

* **Source Code**: PatientHistory.medicalHistory.historyOfProcedures.procedureCode (A.2.6.1.3.1 - Procedure code)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Procedure.code
  * **Comment**: 
* **Source Code**: PatientHistory.medicalHistory.historyOfProcedures.description (A.2.6.1.3.2 - Procedure description)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Procedure.text
  * **Comment**: 
* **Source Code**: PatientHistory.medicalHistory.historyOfProcedures.bodySite (A.2.6.1.3.3 - Body site)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Procedure.bodySite
  * **Comment**: 
* **Source Code**: PatientHistory.medicalHistory.historyOfProcedures.bodySite (A.2.6.1.3.3 - Body site)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Procedure.extension:bodySite
  * **Comment**: if details about the body structure have to be provided
* **Source Code**: PatientHistory.medicalHistory.historyOfProcedures.date (A.2.6.1.3.4 - Procedure date)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Procedure.perfomedDateTime
  * **Comment**: 
* **Source Code**: PatientHistory.medicalHistory.historyOfProcedures.reason (A.2.6.1.3.5 - Procedure reason)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Procedure.reasonCode
  * **Comment**: 
* **Source Code**: PatientHistory.medicalHistory.historyOfProcedures.reason (A.2.6.1.3.5 - Procedure reason)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Procedure.reasonReference
  * **Comment**: 
* **Source Code**: PatientHistory.medicalHistory.historyOfProcedures.outcome (A.2.6.1.3.6 - Outcome)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Procedure.outcome
  * **Comment**: 
* **Source Code**: PatientHistory.medicalHistory.historyOfProcedures.focalDevice (A.2.6.1.3.7 - Focal device)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Procedure.focalDevice
  * **Comment**: 

-------

**Group 9**Mapping from [A.2.5 - Patient history (eHN)](StructureDefinition-PatientHistoryCz.md) to [Observation](http://hl7.org/fhir/R4/observation.html)

* **Source Code**: PatientHistory.useOfSubstances.alcohol (A.2.6.4.1 - Alcohol use)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Observation
  * **Comment**: category and code to be defined
* **Source Code**: PatientHistory.useOfSubstances.alcohol.currentStatus (A.2.6.4.1.1 - Status)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Observation.value[x]
  * **Comment**: category and code to be defined
* **Source Code**: PatientHistory.useOfSubstances.alcohol.periodAndQuantity (A.2.6.4.1.2 - Period and quantity)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Observation.value[x]
  * **Comment**: category and code to be defined
* **Source Code**: PatientHistory.useOfSubstances.alcohol.comment (A.2.6.4.1.3 - Comment)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Observation.note
  * **Comment**: category and code to be defined
* **Source Code**: PatientHistory.useOfSubstances.tobacco (A.2.6.4.2 - Tobacco use)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Observation
  * **Comment**: category and code to be defined
* **Source Code**: PatientHistory.useOfSubstances.tobacco.currentStatus (A.2.6.4.2.1 - Status)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Observation.value[x]
  * **Comment**: category and code to be defined
* **Source Code**: PatientHistory.useOfSubstances.tobacco.periodAndQuantity (A.2.6.4.2.2 - Period and quantity)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Observation.value[x]
  * **Comment**: category and code to be defined
* **Source Code**: PatientHistory.useOfSubstances.tobacco.comment (A.2.6.4.2.3 - Comment)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Observation.note
  * **Comment**: category and code to be defined
* **Source Code**: PatientHistory.useOfSubstances.drugConsumption (A.2.6.4.3 - Drug consumption)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Observation
  * **Comment**: category and code to be defined
* **Source Code**: PatientHistory.useOfSubstances.drugConsumption.currentStatus (A.2.6.4.3.1 - Status)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Observation.value[x]
  * **Comment**: category and code to be defined
* **Source Code**: PatientHistory.useOfSubstances.drugConsumption.periodAndQuantity (A.2.6.4.3.2 - Period and quantity)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Observation.value[x]
  * **Comment**: category and code to be defined
* **Source Code**: PatientHistory.useOfSubstances.drugConsumption.drugType (A.2.6.4.3.3 - Drug or medication type)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Observation
  * **Comment**: category and code to be defined
* **Source Code**: PatientHistory.useOfSubstances.drugConsumption.route (A.2.6.4.3.4 - Route of administration)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Observation.value[x]
  * **Comment**: category and code to be defined
* **Source Code**: PatientHistory.useOfSubstances.drugConsumption.comment (A.2.6.4.3.5 - Comment)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Observation.note
  * **Comment**: category and code to be defined

-------

**Group 10**Mapping from [A.2.5 - Patient history (eHN)](StructureDefinition-PatientHistoryCz.md) to [FamilyMemberHistory](http://hl7.org/fhir/R4/familymemberhistory.html)

* **Source Code**: PatientHistory.familyHistory.relationship (A.2.6.2.1 - Patient relationship)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: FamilyMemberHistory.relationship
  * **Comment**: 
* **Source Code**: PatientHistory.familyHistory.birthDate (A.2.6.2.2 - Date of birth)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: FamilyMemberHistory.bornDate
  * **Comment**: 
* **Source Code**: PatientHistory.familyHistory.deathDateOrAge (A.2.6.2.3 - Age or date of death)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: FamilyMemberHistory.deceased[x]
  * **Comment**: 
* **Source Code**: PatientHistory.familyHistory.conditions (A.2.6.2.5 - Condition)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: FamilyMemberHistory.condition.code
  * **Comment**: 
* **Source Code**: PatientHistory.familyHistory.causeOfDeath (A.2.6.2.6 - Cause of death)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: FamilyMemberHistory.condition.code
  * **Comment**: If FamilyMemberHistory.condition.contributedToDeath is true

-------

**Group 11**Mapping from [A.2.5 - Patient history (eHN)](StructureDefinition-PatientHistoryCz.md) to [Observation: Infectious Contact (HDR CZ)](StructureDefinition-cz-observation-infectious-contact-hdr.md)

* **Source Code**: PatientHistory.medicalHistory.epidemiologicalHistory.infectiousContacts.period (A.2.6.1.5.1.1 - Time period)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Observation.effective[x]
  * **Comment**: 
* **Source Code**: PatientHistory.medicalHistory.epidemiologicalHistory.infectiousContacts.infectiousAgent (A.2.6.1.5.1.2 - Infectious agent)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Observation.valueCodeableConcept
  * **Comment**: In the current value set the disease is indicated
* **Source Code**: PatientHistory.medicalHistory.epidemiologicalHistory.infectiousContacts.proximity (A.2.6.1.5.1.3 - Proximity)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:infectiousContacts
  * **Comment**: in this version as textual description
* **Source Code**: PatientHistory.medicalHistory.epidemiologicalHistory.infectiousContacts.country (A.2.6.1.5.1.4 - Country)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:infectiousContacts
  * **Comment**: in this version as textual description
* **Source Code**: PatientHistory.medicalHistory.epidemiologicalHistory.infectiousContacts.note (A.2.6.1.5.1.5 - Additional information)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Observation.note
  * **Comment**: 

 IG © 2025+ [HL7 Czech Republic](https://www.hl7.cz/). Package hl7.fhir.cz.hdr#0.0.2 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

