# eHN Objective Findings Model to this guide Map - HL7 Czech Hospital Discharge Report Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **eHN Objective Findings Model to this guide Map**

HL7 Czech Hospital Discharge Report Implementation Guide, published by HL7 Czech Republic. This guide is not an authorized publication; it is the continuous build for version 0.0.2 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7-cz/hdr/](https://github.com/HL7-cz/hdr/) and changes regularly. See the [Directory of published versions](https://hl7.cz/fhir/hdr/history.html)

*  [Narrative Content](#) 
*  [XML](ConceptMap-objectiveFindings2FHIR-hdr-cz.xml.md) 
*  [JSON](ConceptMap-objectiveFindings2FHIR-hdr-cz.json.md) 
*  [TTL](ConceptMap-objectiveFindings2FHIR-hdr-cz.ttl.md) 

## ConceptMap: eHN Objective Findings Model to this guide Map (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/ConceptMap/objectiveFindings2FHIR-hdr-cz | *Version*:0.0.2 |
| Draft as of 2025-10-01 | *Computable Name*:ObjectiveFindings2FHIREuHdr |

 
eHN HDR Objective Findings Model to this guide Map 

Mapping from (not specified) to (not specified)

**Group 1**Mapping from [A.2.8.1 Objektivní nález](StructureDefinition-LogCzObjectiveFindingsCz.md) to [Composition (HDR CZ)](StructureDefinition-cz-composition-hdr.md)

* **Source Code**: ObjectiveFindings.anthropometricObservations (A.2.8.1.3 - Anthropometric observations)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section
* **Source Code**: ObjectiveFindings.vitalSigns (A.2.8.1.4 - Vital signs)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:sectionVitalSigns
* **Source Code**: ObjectiveFindings.physicalExamination (A.2.8.1.5 - Physical examination)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:sectionPhysicalExamination
* **Source Code**: ObjectiveFindings.physicalExamination.description (A.2.8.1.5.1 - Observation Note)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:sectionPhysicalExamination.text

-------

**Group 2**Mapping from [A.2.8.1 Objektivní nález](StructureDefinition-LogCzObjectiveFindingsCz.md) to [Observation](http://hl7.org/fhir/R4/observation.html)

* **Source Code**: ObjectiveFindings.date (A.2.8.1.1 - Date)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Observation.effectiveDateTime

-------

**Group 3**Mapping from [A.2.8.1 Objektivní nález](StructureDefinition-LogCzObjectiveFindingsCz.md) to [Vital Signs Profile](http://hl7.org/fhir/R4/vitalsigns.html)

* **Source Code**: ObjectiveFindings.anthropometricObservations.description (A.2.8.1.3.1 - Result description)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Observation.text
* **Source Code**: ObjectiveFindings.anthropometricObservations.details (A.2.8.1.3.2 - Observation details)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Observation
* **Source Code**: ObjectiveFindings.anthropometricObservations.result (A.2.8.1.3.3 - Observation result)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Observation.value[x]
* **Source Code**: ObjectiveFindings.vitalSigns.description (A.2.8.1.4.1 - Result description)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Observation.text
* **Source Code**: ObjectiveFindings.vitalSigns.details (A.2.8.1.4.2 - Observation details)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Observation
* **Source Code**: ObjectiveFindings.vitalSigns.result (A.2.8.1.4.3 - Observation result)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Observation.value[x]

 IG © 2025+ [HL7 Czech Republic](https://www.hl7.cz/). Package hl7.fhir.cz.hdr#0.0.2 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

