# eHN Medication Summary Model to this guide Map - HL7 Czech Hospital Discharge Report Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **eHN Medication Summary Model to this guide Map**

HL7 Czech Hospital Discharge Report Implementation Guide, published by HL7 Czech Republic. This guide is not an authorized publication; it is the continuous build for version 0.0.2 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7-cz/hdr/](https://github.com/HL7-cz/hdr/) and changes regularly. See the [Directory of published versions](https://hl7.cz/fhir/hdr/history.html)

*  [Narrative Content](#) 
*  [XML](ConceptMap-medicationSummary2FHIR-cz-hdr.xml.md) 
*  [JSON](ConceptMap-medicationSummary2FHIR-cz-hdr.json.md) 
*  [TTL](ConceptMap-medicationSummary2FHIR-cz-hdr.ttl.md) 

## ConceptMap: eHN Medication Summary Model to this guide Map (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/ConceptMap/medicationSummary2FHIR-cz-hdr | *Version*:0.0.2 |
| Draft as of 2025-10-01 | *Computable Name*:MedicationSummary2FHIRCzHdr |

 
eHN HDR Medication Summary Model to this guide Map 

Mapping from (not specified) to (not specified)

**Group 1**Mapping from [A.2.8.2 - Medication summary](StructureDefinition-MedicationSummaryCz.md) to [Medication (CZ)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-Medication.html)

* **Source Code**: MedicationSummary.productCode (A.2.9.2.3 - Code)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Medication.code
  * **Comment**: Preferred mapping
* **Source Code**: MedicationSummary.productName (A.2.9.2.4 - Brand name)
  * **Relationship**: [is equal to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equal)
  * **Target Code**: Medication.extension:productName
  * **Comment**: 
* **Source Code**: MedicationSummary.activeIngredient (A.2.9.2.5 - Active ingredient list)
  * **Relationship**: [is equal to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equal)
  * **Target Code**: Medication.ingredient.item[x]
  * **Comment**: Medication.ingredient.isActive = true
* **Source Code**: MedicationSummary.strength (A.2.9.2.6 - Strength)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Medication.ingredient.strength
  * **Comment**: 
* **Source Code**: MedicationSummary.doseForm (A.2.9.2.7 - Pharmaceutical dose form)
  * **Relationship**: [is equal to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equal)
  * **Target Code**: Medication.form
  * **Comment**: 

-------

**Group 2**Mapping from [A.2.8.2 - Medication summary](StructureDefinition-MedicationSummaryCz.md) to [MedicationDispense](http://hl7.org/fhir/R4/medicationdispense.html)

* **Source Code**: MedicationSummary.productCode (A.2.9.2.3 - Code)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: MedicationDispense.medicationCodeableConcept
  * **Comment**: If no details about the medication are provided

-------

**Group 3**Mapping from [A.2.8.2 - Medication summary](StructureDefinition-MedicationSummaryCz.md) to [MedicationRequest (HDR CZ)](StructureDefinition-cz-medicationRequest-hdr.md)

* **Source Code**: MedicationSummary.reason (A.2.9.2.1 - Medication reason)
  * **Relationship**: [is equal to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equal)
  * **Target Code**: MedicationRequest.status
  * **Comment**: As reason for ordering
* **Source Code**: MedicationSummary.changeReason (A.2.9.2.2 - Reason for change)
  * **Relationship**: [is equal to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equal)
  * **Target Code**: MedicationRequest.statusReason
  * **Comment**: 
* **Source Code**: MedicationSummary.productCode (A.2.9.2.3 - Code)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: MedicationRequest.medicationCodeableConcept
  * **Comment**: If no details about the medication are provided
* **Source Code**: MedicationSummary.daysSupplied (A.2.9.2.11 - Days supplied)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: MedicationDispense.daysSupply
  * **Comment**: 

-------

**Group 4**Mapping from [A.2.8.2 - Medication summary](StructureDefinition-MedicationSummaryCz.md) to [Dosage](http://hl7.org/fhir/R4/datatypes.html#Dosage)

* **Source Code**: MedicationSummary.dosageRegimen (A.2.9.2.8 - Dosage Regimen)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Dosage
  * **Comment**: MedicationRequest.dosageInstruction or MedicationDispense.dosageInstruction
* **Source Code**: MedicationSummary.route (A.2.9.2.9 - Route of administration)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Dosage.route
  * **Comment**: 
* **Source Code**: MedicationSummary.period (A.2.9.2.10 - Period of treatment)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Dosage.timing.repeat.duration
  * **Comment**: CHECK it is used the name period but the imression is that is the duration not the period

 IG © 2025+ [HL7 Czech Republic](https://www.hl7.cz/). Package hl7.fhir.cz.hdr#0.0.2 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

