# eHN Hospital Stay Model to this guide Map - HL7 Czech Hospital Discharge Report Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **eHN Hospital Stay Model to this guide Map**

HL7 Czech Hospital Discharge Report Implementation Guide, published by HL7 Czech Republic. This guide is not an authorized publication; it is the continuous build for version 0.0.2 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7-cz/hdr/](https://github.com/HL7-cz/hdr/) and changes regularly. See the [Directory of published versions](https://hl7.cz/fhir/hdr/history.html)

*  [Narrative Content](#) 
*  [XML](ConceptMap-hospitalStay2FHIR-cz-hdr.xml.md) 
*  [JSON](ConceptMap-hospitalStay2FHIR-cz-hdr.json.md) 
*  [TTL](ConceptMap-hospitalStay2FHIR-cz-hdr.ttl.md) 

## ConceptMap: eHN Hospital Stay Model to this guide Map (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/ConceptMap/hospitalStay2FHIR-cz-hdr | *Version*:0.0.2 |
| Draft as of 2025-10-01 | *Computable Name*:HospitalStay2FHIRCzHdr |

 
eHN HDR Hospital Stay Model to this guide Map 

Mapping from (not specified) to (not specified)

**Group 1**Mapping from [A.2.6 - Hospital stay (eHN)](StructureDefinition-HospitalStayCz.md) to [Composition (HDR CZ)](StructureDefinition-cz-composition-hdr.md)

* **Source Code**: HospitalStay.diagnosticSummary (A.2.7.1 - Diagnostic summary)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Composition.section:sectionDiagnosticSummary
  * **Comment**: Details in the Composition.section:sectionDiagnosticSummary.entry of type Condition. See dedicated group
* **Source Code**: HospitalStay.significantProcedures (A.2.7.2 - Significant procedures)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Composition.section:sectionSignificantProcedures
  * **Comment**: Details in the Composition.section:sectionSignificantProcedures.entry of type Procedure. See dedicated group
* **Source Code**: HospitalStay.medicalDevices (A.2.7.3 - Medical devices and implants)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Composition.section:sectionMedicalDevices
  * **Comment**: Details in the Composition.section:sectionMedicalDevices.entry of type DeviceUseStatement. See dedicated groups
* **Source Code**: HospitalStay.pharmacotherapy (A.2.7.5 - Pharmacotherapy)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:sectionPharmacotherapy
  * **Comment**: Details in the Composition.section:sectionPharmacotherapy.entry. See dedicated groups
* **Source Code**: HospitalStay.significantResults (A.2.7.6 - Significant Observation Results)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:sectionSignificantResults
  * **Comment**: 
* **Source Code**: HospitalStay.significantResults.details (A.2.7.6.4 - Observation details)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:sectionSignificantResults.text
  * **Comment**: 
* **Source Code**: HospitalStay.synthesis (A.2.7.7 - Synthesis)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:sectionSynthesis
  * **Comment**: 
* **Source Code**: HospitalStay.synthesis.description (A.2.7.7.1 - Problem synthesis)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:sectionSynthesis.text
  * **Comment**: 
* **Source Code**: HospitalStay.synthesis.reasoning (A.2.7.7.2 - Clinical reasoning)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:sectionSynthesis.text
  * **Comment**: 

-------

**Group 2**Mapping from [A.2.6 - Hospital stay (eHN)](StructureDefinition-HospitalStayCz.md) to [Condition (HDR CZ)](StructureDefinition-cz-condition-hdr.md)

* **Source Code**: HospitalStay.diagnosticSummary.problemDescription (A.2.7.1.1 - Problem description)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Condition.text
  * **Comment**: 
* **Source Code**: HospitalStay.diagnosticSummary.problemDetails (A.2.7.1.2 - Problem details)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Condition
  * **Comment**: 
* **Source Code**: HospitalStay.diagnosticSummary.onsetDate (A.2.7.1.3 - Onset date)
  * **Relationship**: [is equal to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equal)
  * **Target Code**: Condition.onSetDateTime
  * **Comment**: 
* **Source Code**: HospitalStay.diagnosticSummary.endDate (A.2.7.1.4 - End date)
  * **Relationship**: [is equal to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equal)
  * **Target Code**: Condition.abatementDateTime
  * **Comment**: 
* **Source Code**: HospitalStay.diagnosticSummary.category (A.2.7.1.5 - Category)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Condition.category:poa
  * **Comment**: 
* **Source Code**: HospitalStay.diagnosticSummary.treatmentClass (A.2.7.1.6 - Treatment class)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Condition.category:treated
  * **Comment**: 
* **Source Code**: HospitalStay.diagnosticSummary.clinicalStatus (A.2.7.1.7 - Clinical status)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Condition.clinicalStatus
  * **Comment**: 
* **Source Code**: HospitalStay.diagnosticSummary.resolution (A.2.7.1.8 - Resolution circumstances)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Condition.text
  * **Comment**: The resolution circumstances may be described as resource or composiiton.section text ; or indirectly determined by the resource (e.g. Procedure) that has been perfomed in reason of this Condition no more active
* **Source Code**: HospitalStay.diagnosticSummary.severity (A.2.7.1.9 - Severity)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Condition.severity
  * **Comment**: 
* **Source Code**: HospitalStay.diagnosticSummary.stage (A.2.7.1.10 - Stage)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Condition.stage
  * **Comment**: 

-------

**Group 3**Mapping from [A.2.6 - Hospital stay (eHN)](StructureDefinition-HospitalStayCz.md) to [Medical Device (CZ)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-medical-device.html)

* **Source Code**: HospitalStay.medicalDevices.description (A.2.7.3.1 - Device and implant description)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Device.text
  * **Comment**: if referring to the description of the device
* **Source Code**: HospitalStay.medicalDevices.identifier (A.2.7.3.2 - Device ID)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Device.identifier
  * **Comment**: if generic identifier
* **Source Code**: HospitalStay.medicalDevices.identifier (A.2.7.3.2 - Device ID)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Device.udiCarrier
  * **Comment**: if it is the udiCarrier

-------

**Group 4**Mapping from [A.2.6 - Hospital stay (eHN)](StructureDefinition-HospitalStayCz.md) to [DeviceUseStatement (HDR)](StructureDefinition-cz-deviceUseStatement-hdr.md)

* **Source Code**: HospitalStay.medicalDevices.description (A.2.7.3.1 - Device and implant description)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: DeviceUseStatement.text
  * **Comment**: if referring to the description of the usage of the device
* **Source Code**: HospitalStay.medicalDevices.implantDate (A.2.7.3.3 - Implant date)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: DeviceUseStatement.timing[x]
  * **Comment**: If the usage period is highlighted
* **Source Code**: HospitalStay.medicalDevices.endDate (A.2.7.3.4 - End date)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: DeviceUseStatement.timingPeriod.end
  * **Comment**: 
* **Source Code**: HospitalStay.medicalDevices.reason (A.2.7.3.5 - Reason)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: DeviceUseStatement.reasonCode
  * **Comment**: 
* **Source Code**: HospitalStay.medicalDevices.reason (A.2.7.3.5 - Reason)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: DeviceUseStatement.reasonReference
  * **Comment**: 

-------

**Group 5**Mapping from [A.2.6 - Hospital stay (eHN)](StructureDefinition-HospitalStayCz.md) to [Medication (CZ)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-Medication.html)

* **Source Code**: HospitalStay.pharmacotherapy.productCode (A.2.7.5.2 - Code)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Medication.code
* **Source Code**: HospitalStay.pharmacotherapy.intendedUse (A.2.7.5.3 - Intended use)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Composition.section:sectionPharmacotherapy
* **Source Code**: HospitalStay.pharmacotherapy.productName (A.2.7.5.4 - Brand name)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Medication.extension:productName
* **Source Code**: HospitalStay.pharmacotherapy.activeIngredient (A.2.7.5.5 - Active ingredient list)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Medication.ingredient.item[x]
* **Source Code**: HospitalStay.pharmacotherapy.strength (A.2.7.5.6 - Strength)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Medication.ingredient.strength
* **Source Code**: HospitalStay.pharmacotherapy.doseForm (A.2.7.5.7 - Pharmaceutical dose form)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Medication.form

-------

**Group 6**Mapping from [A.2.6 - Hospital stay (eHN)](StructureDefinition-HospitalStayCz.md) to [MedicationDispense (HDR)](StructureDefinition-cz-medicationDispense-hdr.md)

* **Source Code**: HospitalStay.pharmacotherapy.reason (A.2.7.5.1 - Medication reason)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: MedicationDispense.reasonCode
* **Source Code**: HospitalStay.pharmacotherapy.reason (A.2.7.5.1 - Medication reason)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: MedicationDispense.reasonReference
* **Source Code**: HospitalStay.pharmacotherapy.productCode (A.2.7.5.2 - Code)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: MedicationDispense.medicationCodeableConcept

-------

**Group 7**Mapping from [A.2.6 - Hospital stay (eHN)](StructureDefinition-HospitalStayCz.md) to [MedicationRequest (HDR CZ)](StructureDefinition-cz-medicationRequest-hdr.md)

* **Source Code**: HospitalStay.pharmacotherapy.reason (A.2.7.5.1 - Medication reason)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: MedicationRequest.reasonCode
* **Source Code**: HospitalStay.pharmacotherapy.reason (A.2.7.5.1 - Medication reason)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: MedicationRequest.reasonReference
* **Source Code**: HospitalStay.pharmacotherapy.productCode (A.2.7.5.2 - Code)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: MedicationRequest.medicationCodeableConcept

-------

**Group 8**Mapping from [A.2.6 - Hospital stay (eHN)](StructureDefinition-HospitalStayCz.md) to [Procedure (HDR CZ)](StructureDefinition-cz-procedure-hdr.md)

* **Source Code**: HospitalStay.significantProcedures.procedureCode (A.2.7.2.1 - Procedure code)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Procedure.code
  * **Comment**: 
* **Source Code**: HospitalStay.significantProcedures.description (A.2.7.2.2 - Procedure description)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Procedure.text
  * **Comment**: 
* **Source Code**: HospitalStay.significantProcedures.bodySite (A.2.7.2.3 - Body site)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Procedure.bodySite
  * **Comment**: 
* **Source Code**: HospitalStay.significantProcedures.bodySite (A.2.7.2.3 - Body site)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Procedure.extension:bodySite
  * **Comment**: if details about the body structure have to be provided
* **Source Code**: HospitalStay.significantProcedures.date (A.2.7.2.4 - Procedure date)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Procedure.perfomedDateTime
  * **Comment**: 
* **Source Code**: HospitalStay.significantProcedures.reason (A.2.7.2.5 - Procedure reason)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Procedure.reasonCode
  * **Comment**: 
* **Source Code**: HospitalStay.significantProcedures.reason (A.2.7.2.5 - Procedure reason)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Procedure.reasonReference
  * **Comment**: 
* **Source Code**: HospitalStay.significantProcedures.outcome (A.2.7.2.6 - Outcome)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Procedure.outcome
  * **Comment**: 
* **Source Code**: HospitalStay.significantProcedures.complication (A.2.7.2.7 - Complication)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Procedure.complication
  * **Comment**: 
* **Source Code**: HospitalStay.significantProcedures.complication (A.2.7.2.7 - Complication)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Procedure.complicationDetail
  * **Comment**: 
* **Source Code**: HospitalStay.significantProcedures.focalDevice (A.2.7.2.8 - Focal device)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Procedure.focalDevice
  * **Comment**: 
* **Source Code**: HospitalStay.medicalDevices.implantDate (A.2.7.3.3 - Implant date)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Procedure.perfomed[x]
  * **Comment**: if the implantation procedure is described

-------

**Group 9**Mapping from [A.2.6 - Hospital stay (eHN)](StructureDefinition-HospitalStayCz.md) to [Observation](http://hl7.org/fhir/R4/observation.html)

* **Source Code**: HospitalStay.significantResults.date (A.2.7.6.1 - Date)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Observation.effective[x]
  * **Comment**: Similar Mapping for other Observation profiles
* **Source Code**: HospitalStay.significantResults.status (A.2.7.6.2 - Observation status)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Observation.status
  * **Comment**: Similar Mapping for other Observation profiles
* **Source Code**: HospitalStay.significantResults.description (A.2.7.6.3 - Result description)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Observation.text
  * **Comment**: Similar Mapping for other Observation profiles
* **Source Code**: HospitalStay.significantResults.details (A.2.7.6.4 - Observation details)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Observation
  * **Comment**: Similar Mapping for other Observation profiles
* **Source Code**: HospitalStay.significantResults.result (A.2.7.6.5 - Observation result)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Observation.value[x]
  * **Comment**: Similar Mapping for other Observation profiles
* **Source Code**: HospitalStay.significantResults.result (A.2.7.6.5 - Observation result)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Observation.component.value[x]
  * **Comment**: Similar Mapping for other Observation profiles
* **Source Code**: HospitalStay.significantResults.reporter (A.2.7.6.7 - Reporter)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Observation.performer
  * **Comment**: Similar Mapping for other Observation profiles

-------

**Group 10**Mapping from [A.2.6 - Hospital stay (eHN)](StructureDefinition-HospitalStayCz.md) to [Dosage](http://hl7.org/fhir/R4/datatypes.html#Dosage)

* **Source Code**: HospitalStay.pharmacotherapy.dosageRegimen (A.2.7.5.8 - Dosage Regimen)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Dosage
  * **Comment**: MedicationDispense.dosageInstruction or MedicationRequest.dosageInstruction or MedicationStatement.dosage
* **Source Code**: HospitalStay.pharmacotherapy.route (A.2.7.5.9 - Route of administration)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Dosage.route
  * **Comment**: 
* **Source Code**: HospitalStay.pharmacotherapy.period (A.2.7.5.10 - Period of treatment)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Dosage.timing.repeat.duration
  * **Comment**: 

-------

**Group 11**Mapping from [A.2.6 - Hospital stay (eHN)](StructureDefinition-HospitalStayCz.md) to [MedicationAdministration](http://hl7.org/fhir/R4/medicationadministration.html)

* **Source Code**: HospitalStay.pharmacotherapy.reason (A.2.7.5.1 - Medication reason)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: MedicationAdministration.reasonCode
  * **Comment**: 
* **Source Code**: HospitalStay.pharmacotherapy.reason (A.2.7.5.1 - Medication reason)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: MedicationAdministration.reasonReference
  * **Comment**: 
* **Source Code**: HospitalStay.pharmacotherapy.productCode (A.2.7.5.2 - Code)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: MedicationAdministration.medicationCodeableConcept
  * **Comment**: 
* **Source Code**: HospitalStay.pharmacotherapy.dosageRegimen (A.2.7.5.8 - Dosage Regimen)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: MedicationAdministration
  * **Comment**: several elements used
* **Source Code**: HospitalStay.pharmacotherapy.route (A.2.7.5.9 - Route of administration)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: MedicationAdministration.dosage.route
  * **Comment**: 
* **Source Code**: HospitalStay.pharmacotherapy.period (A.2.7.5.10 - Period of treatment)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: MedicationAdministration.occurencePeriod
  * **Comment**: 

-------

**Group 12**Mapping from [A.2.6 - Hospital stay (eHN)](StructureDefinition-HospitalStayCz.md) to [Medication Statement (CZ)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-MedicationStatement.html)

* **Source Code**: HospitalStay.pharmacotherapy.reason (A.2.7.5.1 - Medication reason)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: MedicationStatement.reasonReference
* **Source Code**: HospitalStay.pharmacotherapy.reason (A.2.7.5.1 - Medication reason)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: MedicationStatement.reasonCode
* **Source Code**: HospitalStay.pharmacotherapy.productCode (A.2.7.5.2 - Code)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: MedicationStatement.medicationCodeableConcept
* **Source Code**: HospitalStay.pharmacotherapy.period (A.2.7.5.10 - Period of treatment)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: MedicationStatement.effectivePeriod

 IG © 2025+ [HL7 Czech Republic](https://www.hl7.cz/). Package hl7.fhir.cz.hdr#0.0.2 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

