# CZ Header Model to this guide Map - HL7 Czech Hospital Discharge Report Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CZ Header Model to this guide Map**

HL7 Czech Hospital Discharge Report Implementation Guide, published by HL7 Czech Republic. This guide is not an authorized publication; it is the continuous build for version 0.0.2 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7-cz/hdr/](https://github.com/HL7-cz/hdr/) and changes regularly. See the [Directory of published versions](https://hl7.cz/fhir/hdr/history.html)

*  [Narrative Content](#) 
*  [XML](ConceptMap-hdrHeader2FHIR-cz-hdr.xml.md) 
*  [JSON](ConceptMap-hdrHeader2FHIR-cz-hdr.json.md) 
*  [TTL](ConceptMap-hdrHeader2FHIR-cz-hdr.ttl.md) 

## ConceptMap: CZ Header Model to this guide Map (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/ConceptMap/hdrHeader2FHIR-cz-hdr | *Version*:0.0.2 |
| Draft as of 2025-10-01 | *Computable Name*:Header2FHIRczHdr |

 
CZ HDR Header Model to this guide mapping 

Mapping from (not specified) to (not specified)

**Group 1**Mapping from [A.1 - Hospital Discharge Report header data element](StructureDefinition-Header.md) to [Organization (CZ core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-organization-core.html)

* **Source Code**: Header.payer.insuranceCode (A.1.3.1 - Health insurance code)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Organization.identifier.KP
* **Source Code**: Header.payer.insuranceName (A.1.3.2 - Health insurance name)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Organization.name

-------

**Group 2**Mapping from [A.1 - Hospital Discharge Report header data element](StructureDefinition-Header.md) to [Coverage (CZ)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-coverage.html)

* **Source Code**: Header.coverage.insuranceNumber (A.1.3.3 - insuranceNumber)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: CZ_Coverage.identifer

-------

**Group 3**Mapping from [A.1 - Hospital Discharge Report header data element](StructureDefinition-Header.md) to [Patient (CZ core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-patient-core.html)

* **Source Code**: Header.subject (A.1.1 - Identification and A.1.2 - related contact information of the Patient/subject)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Patient
  * **Comment**: Composition.subject.ofType(Patient).conformsTo('https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core')
* **Source Code**: Header.payer.insuranceNumber (A.1.3.3 - Health insurance number)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Patient.identifier
  * **Comment**: If treated as one of the Patient identifiers; this applies in some jurisdictions.

-------

**Group 4**Mapping from [A.1 - Hospital Discharge Report header data element](StructureDefinition-Header.md) to [Practitioner Role (CZ core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-practitionerrole-core.html)

* **Source Code**: Header.informationRecipient.identifier (A.1.4.1 - Recipient identifier)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: PractitionerRole.identifier
  * **Comment**: Composition.extension:information-recipient.valueReference.resolve()
* **Source Code**: Header.author (A.1.5 - Author (by whom the Hospital discharge report was/were authored). Multiple authors could be provided.)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: PractitionerRole
  * **Comment**: Composition.author.resolve().ofType(PractitionerRole).confirmsTo('https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core')
* **Source Code**: Header.author.identifier (A.1.5.1 - Author identifier)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: PractitionerRole.identifier
  * **Comment**: 
* **Source Code**: Header.author.name (A.1.5.2 - Author name)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: PractitionerRole.practictioner.name
  * **Comment**: If PractitionerRole
* **Source Code**: Header.author.organizationID (A.1.5.3 - Author organisation ID)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: PractitionerRole.organization.identifier
  * **Comment**: If Organization
* **Source Code**: Header.author.organization (A.1.5.4 - Author organisation)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: PractitionerRole.organization
  * **Comment**: 
* **Source Code**: Header.attester (A.1.6 - Attester (multiple attesters could be provided))
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: PractitionerRole
  * **Comment**: where attester.mode = 'professional' AND Composition.attester.party.resolve().ofType(PractitionerRole).confirmsTo('https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core')
* **Source Code**: Header.attester.identifier (A.1.6.1 - Attester identifier)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: PractitionerRole.identifier
  * **Comment**: 
* **Source Code**: Header.attester.name (A.1.6.2 - Attester name)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: PractitionerRole.practictioner.name
  * **Comment**: 
* **Source Code**: Header.attester.organizationID (A.1.6.3 - Attester organisation ID)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: PractitionerRole.organization.identifier
  * **Comment**: 
* **Source Code**: Header.attester.organization (A.1.6.4 - Attester organisation)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: PractitionerRole.organization
  * **Comment**: 
* **Source Code**: Header.legalAuthenticator (A.1.7 - Legal authenticator (The person taking responsibility for the medical content of the document))
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: PractitionerRole
  * **Comment**: where attester.mode = 'legal' AND Composition.attester.party.resolve().ofType(PractitionerRole).conformsTo('https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core')
* **Source Code**: Header.legalAuthenticator.identifier (A.1.7.1 - Legal authenticator identifier)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: PractitionerRole.identifier
  * **Comment**: where attester.mode = 'legal'
* **Source Code**: Header.legalAuthenticator.name (A.1.7.2 - Legal authenticator name)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: PractitionerRole.practictioner.name
  * **Comment**: where attester.mode = 'legal'
* **Source Code**: Header.legalAuthenticator.organizationID (A.1.7.3 - Legal authenticator organisation ID)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: PractitionerRole.organization.identifier
  * **Comment**: where attester.mode = 'legal'
* **Source Code**: Header.legalAuthenticator.organization (A.1.7.4 - Legal authenticator organisation)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: PractitionerRole.organization
  * **Comment**: where attester.mode = 'legal'

-------

**Group 5**Mapping from [A.1 - Hospital Discharge Report header data element](StructureDefinition-Header.md) to [Bundle (HDR CZ)](StructureDefinition-cz-bundle-hdr.md)

* **Source Code**: Header.documentMetadata.identifier (A.1.8.1 - Document ID)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Bundle.identifier
  * **Comment**: If it is the identifier of a particular report instance
* **Source Code**: Header.documentMetadata.dateTime (A.1.8.4 - Report date and time)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Bundle.timeStamp
  * **Comment**: If it is when this particular version of this report has been assembled into a Bundle.

-------

**Group 6**Mapping from [A.1 - Hospital Discharge Report header data element](StructureDefinition-Header.md) to [Composition (HDR CZ)](StructureDefinition-cz-composition-hdr.md)

* **Source Code**: Header.subject (A.1.1 - Identification and A.1.2 - related contact information of the Patient/subject)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Composition.subject
  * **Comment**: 
* **Source Code**: Header.payer (A.1.3 - Health insurance and payment information - Health insurance information is not always required, however, in some jurisdictions, the insurance number is also used as the patient identifier. It is necessary not just for identification but also forms access to funding for care.)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.extension:basedOn:order
  * **Comment**: To be disucssed if the payor data are conveyed with the request or thorugh other means. Check also the extension to be used.
* **Source Code**: Header.payer (A.1.3 - Health insurance and payment information - Health insurance information is not always required, however, in some jurisdictions, the insurance number is also used as the patient identifier. It is necessary not just for identification but also forms access to funding for care.)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:sectionPayers.entry
  * **Comment**: Composition.section:sectionPayers.entry.ofType(Coverage).conformsTo('https://hl7.cz/fhir/core/StructureDefinition/cz-coverage')
* **Source Code**: Header.informationRecipient (A.1.4 - Information recipient - (intended recipient or recipients of the report), if applicable)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.extension:information-recipient
  * **Comment**: Composition.extension:information-recipient.valueReference.resolve().ofType(PracittionerRole)
* **Source Code**: Header.informationRecipient.name (A.1.4.2 - Recipient name)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: PractitionerRole.practitioner.name
  * **Comment**: 
* **Source Code**: Header.informationRecipient.organizationID (A.1.4.3 - Recipient organisation ID)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: PractitionerRole.practitioner.organization.identifier
  * **Comment**: 
* **Source Code**: Header.informationRecipient.organization (A.1.4.4 - Recipient organisation)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: PractitionerRole.practitioner.organization
  * **Comment**: 
* **Source Code**: Header.informationRecipient.address (A.1.4.5 - Address)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: PractitionerRole.address
  * **Comment**: 
* **Source Code**: Header.informationRecipient.country (A.1.4.6 - Country)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: PractitionerRole.country
  * **Comment**: 
* **Source Code**: Header.informationRecipient.telecom (A.1.4.7 - Telecom)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: PractitionerRole.telecom
  * **Comment**: 
* **Source Code**: Header.author (A.1.5 - Author (by whom the Hospital discharge report was/were authored). Multiple authors could be provided.)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Composition.author
  * **Comment**: 
* **Source Code**: Header.author.dateTime (A.1.5.5 - Date Time)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Composition.date
  * **Comment**: 
* **Source Code**: Header.attester (A.1.6 - Attester (multiple attesters could be provided))
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Composition.attester.party
  * **Comment**: where attester.mode = 'professional'
* **Source Code**: Header.attester.dateTime (A.1.6.5 - Approval date and time)
  * **Relationship**: [is equal to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equal)
  * **Target Code**: Composition.attester.time
  * **Comment**: 
* **Source Code**: Header.legalAuthenticator (A.1.7 - Legal authenticator (The person taking responsibility for the medical content of the document))
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Composition.attester.party
  * **Comment**: where attester.mode = 'legal'
* **Source Code**: Header.legalAuthenticator.dateTime (A.1.7.5 - Authentication date and time)
  * **Relationship**: [is equal to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equal)
  * **Target Code**: Composition.attester.time
  * **Comment**: where attester.mode = 'legal'
* **Source Code**: Header.documentMetadata (A.1.8 - Document metadata)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition
  * **Comment**: 
* **Source Code**: Header.documentMetadata.type (A.1.8.2 - Document type)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Composition.type
  * **Comment**: 
* **Source Code**: Header.documentMetadata.status (A.1.8.3 - Document status)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Composition.status
  * **Comment**: 
* **Source Code**: Header.documentMetadata.dateTime (A.1.8.4 - Report date and time)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Composition.date
  * **Comment**: If it is when this document has been created (indipendently by its version)
* **Source Code**: Header.documentMetadata.title (A.1.8.5 - Document title)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Composition.title
  * **Comment**: 
* **Source Code**: Header.documentMetadata.custodian (A.1.8.6 - Report custodian)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Composition.custodian
  * **Comment**: 
* **Source Code**: Header.documentMetadata.confidentiality (A.1.8.7 - Confidentiality)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Composition.confidentiality
  * **Comment**: 
* **Source Code**: Header.documentMetadata.language (A.1.8.8 - Language)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.language
  * **Comment**: 
* **Source Code**: Header.documentMetadata.version (A.1.8.9 - Version)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Composition.extension:versionNumber.valueString
  * **Comment**: As business version, not as resource version

 IG © 2025+ [HL7 Czech Republic](https://www.hl7.cz/). Package hl7.fhir.cz.hdr#0.0.2 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

