# CZ HDR Model to this guide Map - HL7 Czech Hospital Discharge Report Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CZ HDR Model to this guide Map**

HL7 Czech Hospital Discharge Report Implementation Guide, published by HL7 Czech Republic. This guide is not an authorized publication; it is the continuous build for version 0.0.2 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7-cz/hdr/](https://github.com/HL7-cz/hdr/) and changes regularly. See the [Directory of published versions](https://hl7.cz/fhir/hdr/history.html)

*  [Narrative Content](#) 
*  [XML](ConceptMap-hdr2FHIR-cz-hdr.xml.md) 
*  [JSON](ConceptMap-hdr2FHIR-cz-hdr.json.md) 
*  [TTL](ConceptMap-hdr2FHIR-cz-hdr.ttl.md) 

## ConceptMap: CZ HDR Model to this guide Map (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/ConceptMap/hdr2FHIR-cz-hdr | *Version*:0.0.2 |
| Draft as of 2025-10-01 | *Computable Name*:Hdr2FHIRCzHdr |

 
CZ Hospital Discharge Report Model to this guide mapping 

Mapping from (not specified) to (not specified)

**Group 1**Mapping from [A - Hospital Discharge Report (eHN)](StructureDefinition-HospitalDischargeReportCz.md) to [Bundle (HDR CZ)](StructureDefinition-cz-bundle-hdr.md)

* **Source Code**: HospitalDischargeReport.header (A.1 - Hospital Discharge Report header data element)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Bundle
  * **Comment**: See the header model and map for details

-------

**Group 2**Mapping from [A - Hospital Discharge Report (eHN)](StructureDefinition-HospitalDischargeReportCz.md) to [Composition (HDR CZ)](StructureDefinition-cz-composition-hdr.md)

* **Source Code**: HospitalDischargeReport.body (A.2 - Hospital Discharge Report body data element)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition
  * **Comment**: See details below
* **Source Code**: HospitalDischargeReport.body.presentedForm (A.4 - Hospital Discharge Report in its narrative form)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.extension:relatedArtefact.valueRelatedArtefact.document
  * **Comment**: Attachment (e.g., application/pdf) holding the presented form
* **Source Code**: HospitalDischargeReport.body.advanceDirectives (A.2.1 - Advance directives)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:sectionAdvanceDirectives
  * **Comment**: Advance directives section
* **Source Code**: HospitalDischargeReport.body.alerts (A.2.2 - Alerts)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:sectionAlert
  * **Comment**: See the Alerts model and map for details
* **Source Code**: HospitalDischargeReport.body.encounter (A.2.3 - Encounter)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.encounter
  * **Comment**: See the InPatientEncounter model and map for details
* **Source Code**: HospitalDischargeReport.body.admissionEvaluation (A.2.4 - Admission evaluation)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:sectionAdmissionEvaluation
  * **Comment**: Admission evaluation (with potential subsections)
* **Source Code**: HospitalDischargeReport.body.patientHistory (A.2.5 - Patient history)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:sectionPatientHx
  * **Comment**: Narrative patient history section
* **Source Code**: HospitalDischargeReport.body.hospitalStay (A.2.6 - Course of hospitalisation (Hospital stay))
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:sectionHospitalCourse
  * **Comment**: Hospital course narrative + entries
* **Source Code**: HospitalDischargeReport.body.dischargeDetails (A.2.7 - Discharge details)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:sectionDischargeDetails
  * **Comment**: Container for discharge subsections and narrative
* **Source Code**: HospitalDischargeReport.body.dischargeDetails.objectiveFindings (A.2.7.1 - Objective findings)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:sectionDischargeDetails.section:sectionPhysicalExamination
  * **Comment**: 
* **Source Code**: HospitalDischargeReport.body.dischargeDetails.functionalStatus (A.2.7.2 - Functional status)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:sectionDischargeDetails.section:sectionFunctionalStatus
  * **Comment**: 
* **Source Code**: HospitalDischargeReport.body.dischargeDetails.dischargeNote (A.2.7.3 - Discharge note)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:sectionDischargeDetails
  * **Comment**: 
* **Source Code**: HospitalDischargeReport.body.recommendations (A.2.8 - Care plan and other recommendations after discharge.)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section
  * **Comment**: Potentially covered by several sections
* **Source Code**: HospitalDischargeReport.body.recommendations.carePlan (A.2.8.1 - Care plan)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:sectionPlanOfCare
  * **Comment**: 
* **Source Code**: HospitalDischargeReport.body.recommendations.medicationSummary (A.2.8.2 - Medication summary)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:sectionPharmacotherapy
  * **Comment**: CZ guide uses Pharmacotherapy section; use Discharge Medications if present in jurisdiction
* **Source Code**: HospitalDischargeReport.body.recommendations.otherRecommendations (A.2.8.3 - Other recommendations)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:sectionDischargeInstructions
  * **Comment**: 

 IG © 2025+ [HL7 Czech Republic](https://www.hl7.cz/). Package hl7.fhir.cz.hdr#0.0.2 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

