# eHN Functional Status Model to this guide Map - HL7 Czech Hospital Discharge Report Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **eHN Functional Status Model to this guide Map**

HL7 Czech Hospital Discharge Report Implementation Guide, published by HL7 Czech Republic. This guide is not an authorized publication; it is the continuous build for version 0.0.2 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7-cz/hdr/](https://github.com/HL7-cz/hdr/) and changes regularly. See the [Directory of published versions](https://hl7.cz/fhir/hdr/history.html)

*  [Narrative Content](#) 
*  [XML](ConceptMap-functionalStatus2FHIR-hdr-cz.xml.md) 
*  [JSON](ConceptMap-functionalStatus2FHIR-hdr-cz.json.md) 
*  [TTL](ConceptMap-functionalStatus2FHIR-hdr-cz.ttl.md) 

## ConceptMap: eHN Functional Status Model to this guide Map (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/ConceptMap/functionalStatus2FHIR-hdr-cz | *Version*:0.0.2 |
| Draft as of 2025-10-01 | *Computable Name*:FunctionalStatus2FHIREuHdr |

 
eHN HDR Functional Status Model to this guide Map 

Mapping from (not specified) to (not specified)

**Group 1**Mapping from [A.2.8.2 - Functional status](StructureDefinition-FunctionalStatusCz.md) to [Composition (HDR CZ)](StructureDefinition-cz-composition-hdr.md)

* **Source Code**: FunctionalStatus.description (A.2.8.2.1 - Description)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:sectionFunctionalStatus.text

-------

**Group 2**Mapping from [A.2.8.2 - Functional status](StructureDefinition-FunctionalStatusCz.md) to [ClinicalImpression](http://hl7.org/fhir/R4/clinicalimpression.html)

* **Source Code**: FunctionalStatus.assessmentType (A.2.8.2.3 - Functional assessment description)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: ClinicalImpression.code
* **Source Code**: FunctionalStatus.assessmentDate (A.2.8.2.4 - Functional assessment date)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: ClinicalImpression.effective[x]
* **Source Code**: FunctionalStatus.assessmentResult (A.2.8.2.5 - Functional assessment result)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: ClinicalImpression.finding

-------

**Group 3**Mapping from [A.2.8.2 - Functional status](StructureDefinition-FunctionalStatusCz.md) to [Condition (HDR CZ)](StructureDefinition-cz-condition-hdr.md)

* **Source Code**: FunctionalStatus.description (A.2.8.2.1 - Description)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Condition.text
* **Source Code**: FunctionalStatus.onsetDate (A.2.8.2.2 - Onset Date)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Condition.onsetDateTime

 IG © 2025+ [HL7 Czech Republic](https://www.hl7.cz/). Package hl7.fhir.cz.hdr#0.0.2 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

