# eHN Encounter Model to this guide Map - HL7 Czech Hospital Discharge Report Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **eHN Encounter Model to this guide Map**

HL7 Czech Hospital Discharge Report Implementation Guide, published by HL7 Czech Republic. This guide is not an authorized publication; it is the continuous build for version 0.0.2 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7-cz/hdr/](https://github.com/HL7-cz/hdr/) and changes regularly. See the [Directory of published versions](https://hl7.cz/fhir/hdr/history.html)

*  [Narrative Content](#) 
*  [XML](ConceptMap-encounter2FHIR-cz-hdr.xml.md) 
*  [JSON](ConceptMap-encounter2FHIR-cz-hdr.json.md) 
*  [TTL](ConceptMap-encounter2FHIR-cz-hdr.ttl.md) 

## ConceptMap: eHN Encounter Model to this guide Map (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/ConceptMap/encounter2FHIR-cz-hdr | *Version*:0.0.2 |
| Draft as of 2025-10-01 | *Computable Name*:Encounter2FHIRCzHdr |

 
eHN HDR Encounter Model to this guide mapping 

Mapping from (not specified) to (not specified)

**Group 1**Mapping from [A.2.3 - Encounter (eHN)](StructureDefinition-InPatientEncounterCz.md) to [Organization (CZ core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-organization-core.html)

* **Source Code**: Encounter.admission.admitter.organizationID (A.2.3.3.5 - Admitting organisation ID)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Organization.identifier
  * **Comment**: Encounter.participant.individual.ofType(PractitionerRole).organization and where participant.type is 'ADM'
* **Source Code**: Encounter.admission.referringHP.organizationID (A.2.3.3.10 - Referring organisation ID)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Organization.identifier
  * **Comment**: Encounter.participant.individual.ofType(PractitionerRole).organization and where participant.type is 'REF'
* **Source Code**: Encounter.location.organization.identifier (A.2.3.6.2 - Organisation Part ID)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Organization.identifier
  * **Comment**: Encounter.location.location.managingOrganization
* **Source Code**: Encounter.location.organization.name (A.2.3.6.3 - Organisation Part Name)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Organization.name
  * **Comment**: Encounter.location.location.managingOrganization
* **Source Code**: Encounter.location.organization.details (A.2.3.6.4 - Organisation Part Details)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Organization
  * **Comment**: Encounter.location.location.managingOrganization; to be checked

-------

**Group 2**Mapping from [A.2.3 - Encounter (eHN)](StructureDefinition-InPatientEncounterCz.md) to [Practitioner (CZ core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-practitioner-core.html)

* **Source Code**: Encounter.admission.admitter.identifier (A.2.3.3.3 - Admitting professional ID)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Practitioner.identifier
  * **Comment**: Encounter.participant.individual.ofType(Practitioner) and where participant.type is 'ADM'
* **Source Code**: Encounter.admission.admitter.name (A.2.3.3.4 - Admitting professional name)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Practitioner.name
  * **Comment**: Encounter.participant.individual.ofType(Practitioner) or Encounter.participant.individual.ofType(PractitionerRole).practitioner
* **Source Code**: Encounter.admission.referringHP.identifier (A.2.3.3.8 - Referring professional ID)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Practitioner.identifier
  * **Comment**: Encounter.participant.individual.ofType(Practitioner) and where participant.type is 'REF'
* **Source Code**: Encounter.admission.referringHP.name (A.2.3.3.9 - Referring professional name)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Practitioner.name
  * **Comment**: Encounter.participant.individual.ofType(Practitioner) or Encounter.participant.individual.ofType(PractitionerRole).practitioner

-------

**Group 3**Mapping from [A.2.3 - Encounter (eHN)](StructureDefinition-InPatientEncounterCz.md) to [Practitioner Role (CZ core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-practitionerrole-core.html)

* **Source Code**: Encounter.admission.admitter.identifier (A.2.3.3.3 - Admitting professional ID)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: PractitionerRole.identifier
  * **Comment**: and where participant.type is 'ADM'
* **Source Code**: Encounter.admission.referringHP.identifier (A.2.3.3.8 - Referring professional ID)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: PractitionerRole.identifier
  * **Comment**: and where participant.type is 'REF'

-------

**Group 4**Mapping from [A.2.3 - Encounter (eHN)](StructureDefinition-InPatientEncounterCz.md) to [Encounter (HDR CZ)](StructureDefinition-cz-encounter-hdr.md)

* **Source Code**: Encounter.type (A.2.3.1 - Encounter type)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Encounter.class
  * **Comment**: 
* **Source Code**: Encounter.note (A.2.3.2 - Encounter note)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Encounter.extension:note
  * **Comment**: 
* **Source Code**: Encounter.admission (A.2.3.3 - Admission)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Encounter
  * **Comment**: 
* **Source Code**: Encounter.admission.urgency (A.2.3.3.1 - Admission urgency)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Encounter.priority
  * **Comment**: 
* **Source Code**: Encounter.admission.date (A.2.3.3.2 - Admission date)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Encounter.period.start
  * **Comment**: 
* **Source Code**: Encounter.admission.admitter (Admitting professional)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Encounter.participant.individual
  * **Comment**: where participant.type is 'ADM'
* **Source Code**: Encounter.admission.admitter.organization (A.2.3.3.6 - Admitting organisation)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Encounter.serviceProvider
  * **Comment**: 
* **Source Code**: Encounter.admission.admitter.organization (A.2.3.3.6 - Admitting organisation)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Encounter.participant.individual.organization
  * **Comment**: where participant.type is 'ADM' and Encounter.participant.individual.ofType(PractitionerRole)
* **Source Code**: Encounter.admission.source (A.2.3.3.7 - Admit Source)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Encounter.hospitalization.admitSource
  * **Comment**: 
* **Source Code**: Encounter.admission.referringHP (Referring professional)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Encounter.participant.individual
  * **Comment**: where participant.type is 'REF'
* **Source Code**: Encounter.admission.referringHP.organization (A.2.3.3.11 - Referring organisation)
  * **Relationship**: [is equal to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equal)
  * **Target Code**: Encounter.participant.individual.organization
  * **Comment**: where participant.type is 'REF' and Encounter.participant.individual.ofType(PractitionerRole)
* **Source Code**: Encounter.admissionReason (A.2.3.4 - Admission reason)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Encounter.reasonCode
  * **Comment**: 
* **Source Code**: Encounter.admissionReason (A.2.3.4 - Admission reason)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Encounter.reasonReference
  * **Comment**: 
* **Source Code**: Encounter.admissionReason.code (A.2.3.4.1 - Admission reason)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Encounter.reasonCode
  * **Comment**: 
* **Source Code**: Encounter.admissionReason.comment (A.2.3.4.2 - Admission reason comment)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Encounter.reasonCode.text
  * **Comment**: to be checked
* **Source Code**: Encounter.admissionReason.legalStatus (A.2.3.4.3 - Admission legal status)
  * **Relationship**: (not mapped)
  * **Target Code**: to be checked
* **Source Code**: Encounter.discharge (A.2.3.5 - Discharge)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Encounter
  * **Comment**: 
* **Source Code**: Encounter.discharge.date (A.2.3.5.1 - Discharge date)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Encounter.period.end
  * **Comment**: 
* **Source Code**: Encounter.discharge.destinationType (A.2.3.5.2 - Discharge destination type)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Encounter.hospitalization.dischargeDisposition
  * **Comment**: 
* **Source Code**: Encounter.discharge.destinationLocation (A.2.3.5.3 - Destination location)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Encounter.hospitalization.destination
  * **Comment**: 
* **Source Code**: Encounter.location (A.2.3.6 - Location - All locations/departments where the patient stayed (was boarded) within the hospital.)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Encounter.location
  * **Comment**: 
* **Source Code**: Encounter.location.period (A.2.3.6.1 - Period)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Encounter.location.period
  * **Comment**: 

-------

**Group 5**Mapping from [A.2.3 - Encounter (eHN)](StructureDefinition-InPatientEncounterCz.md) to [Location (CZ core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-location-core.html)

* **Source Code**: Encounter.location.organization (Organization)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Location.managingOrganization
  * **Comment**: Encounter.location.location

 IG © 2025+ [HL7 Czech Republic](https://www.hl7.cz/). Package hl7.fhir.cz.hdr#0.0.2 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

