# CZ Alerts Model to this guide Map - HL7 Czech Hospital Discharge Report Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CZ Alerts Model to this guide Map**

HL7 Czech Hospital Discharge Report Implementation Guide, published by HL7 Czech Republic. This guide is not an authorized publication; it is the continuous build for version 0.0.2 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7-cz/hdr/](https://github.com/HL7-cz/hdr/) and changes regularly. See the [Directory of published versions](https://hl7.cz/fhir/hdr/history.html)

*  [Narrative Content](#) 
*  [XML](ConceptMap-alerts2FHIR-cz-hdr.xml.md) 
*  [JSON](ConceptMap-alerts2FHIR-cz-hdr.json.md) 
*  [TTL](ConceptMap-alerts2FHIR-cz-hdr.ttl.md) 

## ConceptMap: CZ Alerts Model to this guide Map (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/ConceptMap/alerts2FHIR-cz-hdr | *Version*:0.0.2 |
| Draft as of 2025-10-01 | *Computable Name*:Alerts2FHIRCzHdr |

 
eHN HDR Alerts Model to this guide mapping 

Mapping from (not specified) to (not specified)

**Group 1**Mapping from [A.2.2 - Alerts (eHN)](StructureDefinition-AlertsCz.md) to [Allergy Intolerance (HDR CZ)](StructureDefinition-cz-allergyIntolerance-hdr.md)

* **Source Code**: Alerts.allergy (A.2.2.1 - Allergy and Intolerance)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: AllergyIntolerance
* **Source Code**: Alerts.allergy.description (A.2.2.1.1 - Allergy description)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: AllergyIntolerance.text
* **Source Code**: Alerts.allergy.agent (A.2.2.1.2 - Agent or Allergen)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: AllergyIntolerance.code
* **Source Code**: Alerts.allergy.typeOfPropensity (A.2.2.1.3 - Type of propensity)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: AllergyIntolerance.type
* **Source Code**: Alerts.allergy.manifestation (A.2.2.1.4 - Allergy manifestation)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: AllergyIntolerance.reaction.manifestation
* **Source Code**: Alerts.allergy.criticality (A.2.2.1.5 - Criticality)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: AllergyIntolerance.criticality
* **Source Code**: Alerts.allergy.onsetDate (A.2.2.1.6 - Onset date)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: AllergyIntolerance.onset[x]
* **Source Code**: Alerts.allergy.endDate (A.2.2.1.7 - End date)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: AllergyIntolerance.extension:abatement-datetime
* **Source Code**: Alerts.allergy.status (A.2.2.1.8 - Status)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: AllergyIntolerance.clinicalStatus
* **Source Code**: Alerts.allergy.certainty (A.2.2.1.9 - Certainty)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: AllergyIntolerance.verificationStatus
* **Source Code**: Alerts.allergy.lastOccurrence (A.2.2.1.10 - Last Occurence)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: AllergyIntolerance.lastOccurrence

-------

**Group 2**Mapping from [A.2.2 - Alerts (eHN)](StructureDefinition-AlertsCz.md) to [Composition (HDR CZ)](StructureDefinition-cz-composition-hdr.md)

* **Source Code**: Alerts.allergy (A.2.2.1 - Allergy and Intolerance)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:sectionAllergies
* **Source Code**: Alerts.medicalAlerts (A.2.2.2 - Medical alerts (relevant for the respective hospital stay))
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:sectionAlerts
* **Source Code**: Alerts.medicalAlerts.description (A.2.2.2.1 - Healthcare alert description)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:sectionAlerts.text

-------

**Group 3**Mapping from [A.2.2 - Alerts (eHN)](StructureDefinition-AlertsCz.md) to [Flag (HDR CZ)](StructureDefinition-cz-flag-hdr.md)

* **Source Code**: Alerts.medicalAlerts.description (A.2.2.2.1 - Healthcare alert description)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Flag.text
  * **Comment**: TO BE checked
* **Source Code**: Alerts.medicalAlerts.description (A.2.2.2.1 - Healthcare alert description)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Flag.code.text
  * **Comment**: TO BE checked
* **Source Code**: Alerts.medicalAlerts.code (A.2.2.2.3 - Healthcare alert code(s))
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Flag.code
  * **Comment**: TO BE checked (cardinality)
* **Source Code**: Alerts.medicalAlerts.specialistPhysician (A.2.2.2.4 - Healthcare alert specialist physician)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Flag.author
  * **Comment**: TO BE checked
* **Source Code**: Alerts.medicalAlerts.comment (A.2.2.2.5 - Healthcare alert comment)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Flag.text
  * **Comment**: TO BE checked
* **Source Code**: Alerts.medicalAlerts.priority (A.2.2.2.6 - Healthcare alert priority)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Flag.extension:flagPriorityExt
  * **Comment**: TO BE checked
* **Source Code**: Alerts.medicalAlerts.period (A.2.2.2.7 - Healthcare alert period)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Flag.period
  * **Comment**: TO BE checked

 IG © 2025+ [HL7 Czech Republic](https://www.hl7.cz/). Package hl7.fhir.cz.hdr#0.0.2 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

