# CZ Advance Directives Model to this guide Map - HL7 Czech Hospital Discharge Report Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CZ Advance Directives Model to this guide Map**

HL7 Czech Hospital Discharge Report Implementation Guide, published by HL7 Czech Republic. This guide is not an authorized publication; it is the continuous build for version 0.0.2 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7-cz/hdr/](https://github.com/HL7-cz/hdr/) and changes regularly. See the [Directory of published versions](https://hl7.cz/fhir/hdr/history.html)

*  [Narrative Content](#) 
*  [XML](ConceptMap-advanceDirectives2FHIR-cz-hdr.xml.md) 
*  [JSON](ConceptMap-advanceDirectives2FHIR-cz-hdr.json.md) 
*  [TTL](ConceptMap-advanceDirectives2FHIR-cz-hdr.ttl.md) 

## ConceptMap: CZ Advance Directives Model to this guide Map (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/ConceptMap/advanceDirectives2FHIR-cz-hdr | *Version*:0.0.2 |
| Draft as of 2025-10-01 | *Computable Name*:AdvanceDirectives2FHIRCzHdr |

 
eHN HDR Advance Directives Model to this guide mapping 

Mapping from (not specified) to (not specified)

**Group 1**Mapping from [A.2.1 - Advance Directives (eHN)](StructureDefinition-AdvanceDirectivesCz.md) to [Composition (HDR CZ)](StructureDefinition-cz-composition-hdr.md)

* **Source Code**: AdvanceDirectives.livingWill (A.2.1.1 - Living will)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:sectionAdvanceDirectives.text
  * **Comment**: 
* **Source Code**: AdvanceDirectives.livingWill (A.2.1.1 - Living will)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Composition.section:sectionAdvanceDirectives.entry
  * **Comment**: Composition.section:sectionAdvanceDirectives.entry.ofType(Consent)
* **Source Code**: AdvanceDirectives.livingWill.document (A.2.1.1.5 - Living will document)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.section:sectionAdvanceDirectives.entry
  * **Comment**: Composition.section:sectionAdvanceDirectives.entry.ofType(DocumentReference)

-------

**Group 2**Mapping from [A.2.1 - Advance Directives (eHN)](StructureDefinition-AdvanceDirectivesCz.md) to [Consent](http://hl7.org/fhir/R4/consent.html)

* **Source Code**: AdvanceDirectives.livingWill.date (A.2.1.1.1 - Date and time)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Consent.dateTime
  * **Comment**: 
* **Source Code**: AdvanceDirectives.livingWill.type (A.2.1.1.2 - Type)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Consent.category
  * **Comment**: TO BE checked
* **Source Code**: AdvanceDirectives.livingWill.comment (A.2.1.1.3 - Comment)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Consent.text
  * **Comment**: TO BE checked
* **Source Code**: AdvanceDirectives.livingWill.conditions (A.2.1.1.4 - Related conditions)
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Consent.provision.code
  * **Comment**: TO BE checked

 IG © 2025+ [HL7 Czech Republic](https://www.hl7.cz/). Package hl7.fhir.cz.hdr#0.0.2 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

