# CZ Attachment Model to this guide Map - HL7 Czech Hospital Discharge Report Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CZ Attachment Model to this guide Map**

HL7 Czech Hospital Discharge Report Implementation Guide, published by HL7 Czech Republic. This guide is not an authorized publication; it is the continuous build for version 0.0.2 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7-cz/hdr/](https://github.com/HL7-cz/hdr/) and changes regularly. See the [Directory of published versions](https://hl7.cz/fhir/hdr/history.html)

*  [Narrative Content](#) 
*  [XML](ConceptMap-AttachmentHDR2FHIR-cz.xml.md) 
*  [JSON](ConceptMap-AttachmentHDR2FHIR-cz.json.md) 
*  [TTL](ConceptMap-AttachmentHDR2FHIR-cz.ttl.md) 

## ConceptMap: CZ Attachment Model to this guide Map (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/ConceptMap/AttachmentHDR2FHIR-cz | *Version*:0.0.2 |
| Draft as of 2025-10-01 | *Computable Name*:AttachmentHDR2FHIRcz |

 
CZ HDR Attachment Model to this guide mapping 

Mapping from (not specified) to (not specified)

**Group 1**Mapping from [A.4 - Additional attachments](StructureDefinition-AttachmentsCz.md) to [Composition (HDR CZ)](StructureDefinition-cz-composition-hdr.md)

* **Source Code**: Attachments (A.4 - Attachments)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Composition.section:sectionAttachments.entry[x].DocumentReference.content[x].attachment (If it is additional attachments)

-------

**Group 2**Mapping from [A.4 - Additional attachments](StructureDefinition-AttachmentsCz.md) to [Attachment: HDR (CZ)](StructureDefinition-cz-attachment-hdr.md)

* **Source Code**: Attachments.contentType (A.4.1 - Content type of media attachments)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: content[x].attachment.contentType
* **Source Code**: Attachments.language (A.4.2 - Language of media attachments)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: content[x].attachment.language
* **Source Code**: Attachments.data (A.4.3 - Data of media attachments)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: content[x].attachment.data
* **Source Code**: Attachments.url (A.4.4 - URL of media attachments)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: content[x].attachment.url
* **Source Code**: Attachments.title (A.4.5 - Title of media attachments)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: content[x].attachment.title
* **Source Code**: Attachments.creation (A.4.6 - Date and time of creation)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: content[x].attachment.creation

 IG © 2025+ [HL7 Czech Republic](https://www.hl7.cz/). Package hl7.fhir.cz.hdr#0.0.2 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

