# Propouštěcí zpráva - HL7 Czech Hospital Discharge Report Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Propouštěcí zpráva**

HL7 Czech Hospital Discharge Report Implementation Guide, published by HL7 Czech Republic. This guide is not an authorized publication; it is the continuous build for version 0.0.2 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7-cz/hdr/](https://github.com/HL7-cz/hdr/) and changes regularly. See the [Directory of published versions](https://hl7.cz/fhir/hdr/history.html)

*  [Narrative Content](#) 
*  [XML](Composition-6891fd68-dc3c-4c91-a8d3-cb5ec990c03b.xml.md) 
*  [JSON](Composition-6891fd68-dc3c-4c91-a8d3-cb5ec990c03b.json.md) 
*  [TTL](Composition-6891fd68-dc3c-4c91-a8d3-cb5ec990c03b.ttl.md) 

## Example Composition: Propouštěcí zpráva

Language: cs

Profile: [Composition (HDR CZ)](StructureDefinition-cz-composition-hdr.md)

**Extension Definition for Composition.version for Version 5.0**: 1.0.0

**Composition: Presented Form**: application/pdf: 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

**status**: Final

**type**: Hospital Discharge summary

**category**: Discharge summary

**encounter**: [Encounter: status = finished; class = inpatient encounter (ActCode#IMP); priority = emergency; period = 2025-03-01 10:15:00+0100 --> 2025-03-10 09:30:00+0100](Bundle-DischargeBundle-Novak-Petr-L1-plus.md#urn-uuid-10f5c49e-086d-4016-8dd1-b555306bf620)

**date**: 2025-03-10 14:30:00+0100

**author**: 

* [Practitioner MUDr. Ivan Anděl](Bundle-DischargeBundle-Novak-Petr-L1-plus.md#urn-uuid-a81e74c9-fe94-4eb1-9233-4c8f0b2d4e3a)
* [PractitionerRole Lékař](Bundle-DischargeBundle-Novak-Petr-L1-plus.md#urn-uuid-2b7e9637-5018-4542-9faf-d5abdee7b849)
* [Organization Nemocnice Chrudim](Bundle-DischargeBundle-Novak-Petr-L1-plus.md#urn-uuid-ace081ba-e0a8-4b89-a4a7-c5b7cd3c8169)

**title**: Propouštěcí zpráva

**confidentiality**: normal

### Attesters

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Mode** | **Time** | **Party** |
| * | Legal | 2025-03-10 14:30:00+0100 | [Practitioner MUDr. Ivan Anděl](Bundle-DischargeBundle-Novak-Petr-L1-plus.md#urn-uuid-a81e74c9-fe94-4eb1-9233-4c8f0b2d4e3a) |

**custodian**: [Organization Nemocnice Chrudim](Bundle-DischargeBundle-Novak-Petr-L1-plus.md#urn-uuid-ace081ba-e0a8-4b89-a4a7-c5b7cd3c8169)

 IG © 2025+ [HL7 Czech Republic](https://www.hl7.cz/). Package hl7.fhir.cz.hdr#0.0.2 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

