# CZ-CarePlan-HDR Example - HL7 Czech Hospital Discharge Report Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CZ-CarePlan-HDR Example**

HL7 Czech Hospital Discharge Report Implementation Guide, published by HL7 Czech Republic. This guide is not an authorized publication; it is the continuous build for version 0.0.2 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7-cz/hdr/](https://github.com/HL7-cz/hdr/) and changes regularly. See the [Directory of published versions](https://hl7.cz/fhir/hdr/history.html)

*  [Narrative Content](#) 
*  [XML](CarePlan-CZ-CarePlan-HDR-Example.xml.md) 
*  [JSON](CarePlan-CZ-CarePlan-HDR-Example.json.md) 
*  [TTL](CarePlan-CZ-CarePlan-HDR-Example.ttl.md) 

## Example CarePlan: CZ-CarePlan-HDR Example

**status**: Active

**intent**: Plan

**title**: Post-Discharge Care Plan

**description**: Care plan for patient post-discharge following critical heart failure treatment.

**subject**: [Mračena Mrakomorová Female, DoB: 1971-11-26 ( Passport number (use: official, ))](Patient-Mracena2.md)

**period**: 2025-01-10 08:00:00+0100 --> 2025-06-10 08:00:00+0100

**addresses**: [Condition Heart failure](Condition-CZ-Condition-HDR-Example.md)

> **activity**

### Details

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Kind** | **Status** | **Description** |
| * | Appointment | Scheduled | Follow-up appointment with cardiologist |


 IG © 2025+ [HL7 Czech Republic](https://www.hl7.cz/). Package hl7.fhir.cz.hdr#0.0.2 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

