# DischargeBundle-Novak-Petr-L1 - HL7 Czech Hospital Discharge Report Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **DischargeBundle-Novak-Petr-L1**

HL7 Czech Hospital Discharge Report Implementation Guide, published by HL7 Czech Republic. This guide is not an authorized publication; it is the continuous build for version 0.0.2 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7-cz/hdr/](https://github.com/HL7-cz/hdr/) and changes regularly. See the [Directory of published versions](https://hl7.cz/fhir/hdr/history.html)

*  [Narrative Content](#) 
*  [XML](Bundle-DischargeBundle-Novak-Petr-L1.xml.md) 
*  [JSON](Bundle-DischargeBundle-Novak-Petr-L1.json.md) 
*  [TTL](Bundle-DischargeBundle-Novak-Petr-L1.ttl.md) 

## Example Bundle: DischargeBundle-Novak-Petr-L1

**Document Details**

Profile: [Bundle (HDR CZ)](StructureDefinition-cz-bundle-hdr.md)

Final Document at 2025-03-10 14:30:00+0100 by [Practitioner MUDr. Ivan Anděl](Bundle-DischargeBundle-Novak-Petr-L1-plus.md#urn-uuid-a81e74c9-fe94-4eb1-9233-4c8f0b2d4e3a), [PractitionerRole Lékař](Bundle-DischargeBundle-Novak-Petr-L1-plus.md#urn-uuid-2b7e9637-5018-4542-9faf-d5abdee7b849), [Organization Nemocnice Chrudim](Bundle-DischargeBundle-Novak-Petr-L1-plus.md#urn-uuid-ace081ba-e0a8-4b89-a4a7-c5b7cd3c8169) for [Petr Novák Male, DoB: 1985-06-15 ( https://ncez.mzcr.cz/fhir/sid/rid#1597778923)](Bundle-DischargeBundle-Novak-Petr-L1-plus.md#urn-uuid-3f85726c-ad2f-441b-89ce-100000000000) in encounter [Encounter: status = finished; class = inpatient encounter (ActCode#IMP); priority = emergency; period = 2025-03-01 10:15:00+0100 --> 2025-03-10 09:30:00+0100](Bundle-DischargeBundle-Novak-Petr-L1-plus.md#urn-uuid-10f5c49e-086d-4016-8dd1-b555306bf620)

-------

**Document Subject**

Profile: [Patient (CZ core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-patient-core.html)

Petr Novák Male, DoB: 1985-06-15 ( https://ncez.mzcr.cz/fhir/sid/rid#1597778923)

-------

-------

**Document Content**

## Klinické shrnutí

Pacient byl přijat dne 1. 3. 2025 na chirurgické oddělení s bolestivou pravostrannou tříselnou kýlou, která byla nevratná, bez známek strangulace. Během hospitalizace byla provedena předoperační příprava včetně laboratorních vyšetření a interního předoperačního vyšetření. Dne 2. 3. 2025 byla v celkové anestezii provedena operace – plastika pravostranné tříselné kýly. Operační výkon proběhl bez komplikací. Pacient byl pooperačně stabilní, bez známek infekce rány. V rámci hospitalizace byla u pacienta sledována substituční léčba hypotyreózy (Euthyrox 75 µg denně), bez nutnosti úpravy dávkování. Hodnota TSH při přijetí v normě. Pacient byl v dobrém stavu propuštěn do domácího ošetření dne 10. 3. 2025. Doporučena klidová režimová opatření, kontrola v chirurgické ambulanci za 7 dní.

## Přílohy

Přílohy

-------

## Additional Resources Included in Document

-------

Entry 2 - fullUrl = urn:uuid:3f85726c-ad2f-441b-89ce-100000000000

Resource Patient:

> 

Profile: [Patient (CZ core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-patient-core.html)

Petr Novák Male, DoB: 1985-06-15 ( https://ncez.mzcr.cz/fhir/sid/rid#1597778923)
-------

-------

Entry 3 - fullUrl = urn:uuid:a81e74c9-fe94-4eb1-9233-4c8f0b2d4e3a

Resource Practitioner:

> MUDr. Ivan Anděl, interní lékař, Nemocnice Chrudim, Václavská 570, 537 01 Chrudim, tel: +420 603 777 227

-------

Entry 4 - fullUrl = urn:uuid:2b7e9637-5018-4542-9faf-d5abdee7b849

Resource PractitionerRole:

> MUDr. Ivan Anděl, interní lékař, Nemocnice Chrudim, Václavská 570, 537 01 Chrudim, tel: +420 603 777 227

-------

Entry 5 - fullUrl = urn:uuid:ace081ba-e0a8-4b89-a4a7-c5b7cd3c8169

Resource Organization:

> 

Profile: [Organization (CZ core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-organization-core.html)

**identifier**:`https://ncez.mzcr.cz/fhir/sid/krpzs`/27520536**name**: Nemocnice Chrudim

### Contacts

| | | |
| :--- | :--- | :--- |
| - | **Telecom** | **Address** |
| * | [+420603853227](tel:+420603853227) | Václavská 570, 537 01, Chrudim(work) |


-------

Entry 6 - fullUrl = urn:uuid:66678621-df93-47ca-a36c-2a39a92472e7

Resource DocumentReference:

> **status**: Current**type**:Discharge summary**subject**:[Petr Novák Male, DoB: 1985-06-15 ( https://ncez.mzcr.cz/fhir/sid/rid#1597778923)](Bundle-DischargeBundle-Novak-Petr-L1-plus.md#urn-uuid-3f85726c-ad2f-441b-89ce-100000000000)**date**: 2022-10-07 08:15:00+0200**author**:[Practitioner MUDr. Ivan Anděl](Bundle-DischargeBundle-Novak-Petr-L1-plus.md#urn-uuid-a81e74c9-fe94-4eb1-9233-4c8f0b2d4e3a)**custodian**:[Organization Nemocnice Chrudim](Bundle-DischargeBundle-Novak-Petr-L1-plus.md#urn-uuid-ace081ba-e0a8-4b89-a4a7-c5b7cd3c8169)
> **content**

### Attachments

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| - | **ContentType** | **Language** | **Data** | **Title** |
| * | application/pdf | cs | (base64 data - 186,368 base64 chars) | Propouštěcí zpráva |



-------

Entry 7 - fullUrl = urn:uuid:cdae7735-f7ee-4bc7-9cf3-3dc806a4eaab

Resource Provenance:

> 

Profile: [Provenance (CZ)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-provenance.html)

Provenance for Reference(DischargeBundle-Novak-Petr-L1) (Identifier:`https://ncez.mzcr.cz/fhir/sid/ico`/27520536)Summary**Agents**

-------

Entry 8 - fullUrl = urn:uuid:10f5c49e-086d-4016-8dd1-b555306bf620

Resource Encounter:

> 

Profile: [Encounter (HDR CZ)](StructureDefinition-cz-encounter-hdr.md)

**status**: completed**class**:inpatient encounter**priority**:emergency**subject**:[Petr Novák Male, DoB: 1985-06-15 ( https://ncez.mzcr.cz/fhir/sid/rid#1597778923)](Bundle-DischargeBundle-Novak-Petr-L1-plus.md#urn-uuid-3f85726c-ad2f-441b-89ce-100000000000)**serviceProvider**:[Organization MUDr. Jana Krásná](Organization-RegisteringProviderExample.md)
> **participant****type**:Admitter

> **participant****type**:Referrer

> **location****location**:[Location Nemocnice Chrudim - Oddělení CHIR1](Location-cz-Location-Chrudim-Chir1.md)**period**: 2025-03-01 08:00:00+0100 --> 2025-03-02 08:00:00+0100

> **location****location**:[Location Nemocnice Chrudim - Oddělení CHIR-JIP](Location-cz-Location-Chrudim-ChirJIP.md)**period**: 2025-03-02 08:00:00+0100 --> 2025-03-04 08:00:00+0100

> **location****location**:[Location Nemocnice Chrudim - Oddělení CHIR1](Location-cz-Location-Chrudim-Chir1.md)**period**: 2025-03-04 08:00:00+0100 --> 2025-03-10 08:00:00+0100

 IG © 2025+ [HL7 Czech Republic](https://www.hl7.cz/). Package hl7.fhir.cz.hdr#0.0.2 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

