# DischargeBundle-Novak-Petr-L1-core - HL7 Czech Hospital Discharge Report Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **DischargeBundle-Novak-Petr-L1-core**

HL7 Czech Hospital Discharge Report Implementation Guide, published by HL7 Czech Republic. This guide is not an authorized publication; it is the continuous build for version 0.0.2 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7-cz/hdr/](https://github.com/HL7-cz/hdr/) and changes regularly. See the [Directory of published versions](https://hl7.cz/fhir/hdr/history.html)

*  [Narrative Content](#) 
*  [XML](Bundle-1c794aff-876a-41bf-9401-fa8fee3b1e57.xml.md) 
*  [JSON](Bundle-1c794aff-876a-41bf-9401-fa8fee3b1e57.json.md) 
*  [TTL](Bundle-1c794aff-876a-41bf-9401-fa8fee3b1e57.ttl.md) 

## Example Bundle: DischargeBundle-Novak-Petr-L1-core

**Document Details**

Profile: [Bundle (HDR CZ)](StructureDefinition-cz-bundle-hdr.md)

Final Document at 2025-03-10 14:30:00+0100 by [PractitionerRole Lékař](Bundle-1c794aff-876a-41bf-9401-fa8fee3b1e57.md#urn-uuid-69d34ceb-b556-4f75-9e4c-9184fe8a10c5) for [Ing. Petr Novák, Ph.D. Male, DoB: 1985-06-15 ( https://ncez.mzcr.cz/fhir/sid/rid#1597778923)](Bundle-1c794aff-876a-41bf-9401-fa8fee3b1e57.md#urn-uuid-48a9d440-4194-42c1-87ad-b5a39020a4d0) in encounter [Encounter: status = finished; class = inpatient encounter (ActCode#IMP); period = 2025-03-01 10:15:00+0100 --> 2025-03-10 09:30:00+0100](Bundle-1c794aff-876a-41bf-9401-fa8fee3b1e57.md#urn-uuid-f08151d0-a7ad-4a7b-b7b9-97eb1d394ffb)

-------

**Document Subject**

Profile: [Patient (CZ core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-patient-core.html)

Ing. Petr Novák, Ph.D. Male, DoB: 1985-06-15 ( https://ncez.mzcr.cz/fhir/sid/rid#1597778923)

-------

-------

**Document Content**

## Klinické shrnutí

Pacient byl přijat dne 1. 3. 2025 na chirurgické oddělení s bolestivou pravostrannou tříselnou kýlou, která byla nevratná, bez známek strangulace. Během hospitalizace byla provedena předoperační příprava včetně laboratorních vyšetření a interního předoperačního vyšetření. Dne 2. 3. 2025 byla v celkové anestezii provedena operace – plastika pravostranné tříselné kýly. Operační výkon proběhl bez komplikací. Pacient byl pooperačně stabilní, bez známek infekce rány. V rámci hospitalizace byla u pacienta sledována substituční léčba hypotyreózy (Euthyrox 75 µg denně), bez nutnosti úpravy dávkování. Hodnota TSH při přijetí v normě. Pacient byl v dobrém stavu propuštěn do domácího ošetření dne 10. 3. 2025. Doporučena klidová režimová opatření, kontrola v chirurgické ambulanci za 7 dní.

## Přílohy

Přílohy

-------

## Additional Resources Included in Document

-------

Entry 2 - fullUrl = urn:uuid:48a9d440-4194-42c1-87ad-b5a39020a4d0

Resource Patient:

> 

Profile: [Patient (CZ core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-patient-core.html)

Ing. Petr Novák, Ph.D. Male, DoB: 1985-06-15 ( https://ncez.mzcr.cz/fhir/sid/rid#1597778923)
-------

-------

Entry 3 - fullUrl = urn:uuid:e234a53a-4e0d-4fb8-9403-e0e324a50f64

Resource Practitioner:

> 

Profile: [Practitioner (CZ core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-practitioner-core.html)

**identifier**:`https://ncez.mzcr.cz/fhir/sid/krzp`/123456789**name**: MUDr. Ivan Anděl**telecom**:[+420603777227](tel:+420603777227)

-------

Entry 4 - fullUrl = urn:uuid:69d34ceb-b556-4f75-9e4c-9184fe8a10c5

Resource PractitionerRole:

> MUDr. Ivan Anděl, interní lékař, Nemocnice Chrudim, Václavská 570, 537 01 Chrudim, tel: +420 603 777 227

-------

Entry 5 - fullUrl = urn:uuid:9f7c3d74-2c71-4b92-9a59-2b6f37ecb3d1

Resource Organization:

> 

Profile: [Organization (CZ core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-organization-core.html)

**identifier**:`https://ncez.mzcr.cz/fhir/sid/krpzs`/27520536**name**: Nemocnice Chrudim

### Contacts

| | | |
| :--- | :--- | :--- |
| - | **Telecom** | **Address** |
| * | [+420603853227](tel:+420603853227) | Václavská 570, 537 01, Chrudim(work) |


-------

Entry 6 - fullUrl = urn:uuid:cdae7735-f7ee-4bc7-9cf3-3dc806a4eaab

Resource Provenance:

> 

Profile: [Provenance (CZ)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-provenance.html)

Provenance for Reference(DischargeBundle-Novak-Petr-L1) (Identifier:`https://ncez.mzcr.cz/fhir/sid/ico`/27520536)Summary**Agents**

-------

Entry 7 - fullUrl = urn:uuid:f08151d0-a7ad-4a7b-b7b9-97eb1d394ffb

Resource Encounter:

> 

Profile: [Encounter (HDR CZ)](StructureDefinition-cz-encounter-hdr.md)

**status**: completed**class**:inpatient encounter**subject**:[Ing. Petr Novák, Ph.D. Male, DoB: 1985-06-15 ( https://ncez.mzcr.cz/fhir/sid/rid#1597778923)](Bundle-1c794aff-876a-41bf-9401-fa8fee3b1e57.md#urn-uuid-48a9d440-4194-42c1-87ad-b5a39020a4d0)**serviceProvider**:[Organization Nemocnice Chrudim](Bundle-1c794aff-876a-41bf-9401-fa8fee3b1e57.md#urn-uuid-9f7c3d74-2c71-4b92-9a59-2b6f37ecb3d1)

 IG © 2025+ [HL7 Czech Republic](https://www.hl7.cz/). Package hl7.fhir.cz.hdr#0.0.2 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

